; FR.ASM --- TSR source for frequency logger.
;
;make file with turbo asm and linker:
;tasm fr.asm,,nul,nul;
;tlink /t fr,,nul,;
;
; make file with masm, link, exe2bin:
; masm fr.asm,,nul,nul;
; link fr,,nul,;
; exe2bin fr.exe fr.com
; del fr.exe
;
;Purpose: Maintains last access date and time for all files opened
;         by DOS call 3dh by logging the file name to file \freq.dat.
;
;Use:     Start FR.COM. The file \FREQ.DAT will be created if it does not
;         yet exist. File names are appended to the end of the file. The
;         collection file can be deleted, examined, etc, at any time.
;         The dump file name can be changed by a patch in debug: lots of
;         space is provided. At present, the TSR cannot de-install itself
;         but it does detect its own presence.
;
;Version: 17 Jan 1992 [prev: 1 December 1991]
;Authors: Grant B. Gustafson and Greg Conner.
;         Other authors will be added here as contributions are made.
;email:   gustafso@math.utah.edu, conner@math.utah.edu (Internet addresses)
;Copyright:
;         The source code is jointly owned by the authors. It may be used
;         for educational purposes without limitation. Modified versions
;         of the sources are considered private copies and should bear
;         the new authors names but not the present authors names.
;Responsibility:
;         This computer program is used at your own risk. If you use it,
;         then you assume responsibility for anything that happens as a
;         result of the program operation, including but not limited to
;         programming errors, faulty operation, file system destruction.
;         The authors are not responsible.
;
Cseg      segment public para
          assume  cs:Cseg, ds:nothing, es:nothing, ss:nothing

          org     080H
cmdline   label   byte                 ;pointer to command line

          org     100H
comentry: jmp     init


;previous interrupt handlers
        even
dos_int        label dword
old21          dw 2 dup (?)            ;old int21 vector
;***********************************************************************
;interrupt handler for int21
newint21 proc  near
         assume ds:nothing
        pushf                  ;save flags
        push    si
        mov     si,offset fn            ;are we to ignore updates?
        cmp     byte ptr cs:[si],1
        pop     si
        jne     ex21
        cmp     ax,'fr'                 ;check for install twice
        jne     ex20
        popf                            ;tried to install twice
        xor     ax,ax                   ;clear flags
        mov     ax,'co'                 ;return code for install
        iret                            ;return from interrupt
ex20:
        cmp     ah,3dh
        jne    ex21
        call   update                   ;update dir entry
ex21:   popf
        jmp    (dos_int)                ;transfer to previous int21 vector
newint21 endp

;******************************************************************************
;resident data section follows
;******************************************************************************


        even
;temporary stack used by interrupt handler
newss          dw      0               ;segment of our temporary stack
newsp          dw      0               ;initial stack pointer

;information saved about the calling program
oldss          dw      ?               ;stack segment
oldsp          dw      ?               ;stack pointer


;***********************************************************************
;

update proc  near
       assume ds:nothing

;save current stack
       mov     oldss,ss
       mov     oldsp,sp

;switch to our stack
       cli
       mov     ss,newss
       mov     sp,newsp
       sti

;store registers
       push    ax
       push    bx
       push    cx
       push    si
       push    di
       push    es
       push    dx
       push    ds

        call    mungfile                ;full path name needed
        call    openfile                ;open existent file c:\FREQ.DAT
        cmp     ax,0                    ;returns 0 if file not open
        jz      quit
        call    seekend                 ;seek to end of file
        call    writefile               ;write string to file
        call    closefile               ;close c:\FREQ.DAT
quit:
;restore registers
       pop     ds
       pop     dx
       pop     es
       pop     di
       pop     si
       pop     cx
       pop     bx
       pop     ax

;restore stack
       cli
       mov     ss,oldss
       mov     sp,oldsp
       sti

       ret
update endp

mungfile proc near
;copy file name, fix path name to give disk and directory
        assume ds:nothing
        mov     ax,ds
        mov     es,ax
        mov     di,dx                           ;es:di=source string
        mov     ax,cs
        mov     ds,ax
        mov     si,offset path                  ;ds:si=dest string
; check for ':' at position 2 of string
        mov     al,byte ptr es:[di]
        cmp     al,0
        je      loop1exit
        inc     di
        mov     ah,byte ptr es:[di]
        dec     di
        cmp     ah,':'                          ;drive spec present?
        jne     loop1exit                       ;not found
        inc     di
        inc     di
        jmp     loop1success
loop1exit:                                      ;no ':' found
; look up the default drive number
        mov     ah,19h
        int     21h
        add     al,'A'                          ;convert to letter
loop1success:                                   ;found ':'
        mov     bl,al                           ;save drive letter
        mov     byte ptr ds:[si],al
        inc     si
        mov     byte ptr ds:[si],':'
        inc     si
        push    di
; check for '/' or '\' in source string
        mov     al,byte ptr es:[di]
        cmp     al,'\'
        je      loop2success
        cmp     al,'/'
        je      loop2success
getdefault:
;can't find delimiter, so look up default directory
        mov     byte ptr ds:[si],'\'            ;need delimiter
        inc     si
        mov     dl,bl                           ;bl=drive letter
        sub     dl,'A'
        add     dl,1
;       mov     ds,buffer segment
;       mov     si,buffer offset
        push    si
        mov     ah,47h                          ;get current dir name
        int     21h
        pop     si
        jnc     loop3
        dec     si
        mov     byte ptr ds:[si],0
loop3:
        cmp     byte ptr ds:[si],0              ;advance past default
        je      loop2success                    ;dir name
        inc     si
        jmp     loop3
loop2success:
        pop     di
        dec     si
        cmp     byte ptr ds:[si],'\'            ;delimiter already?
        je      loop35                          ;then skip it
        inc     si
loop35:
        mov     al,byte ptr es:[di]
        cmp     al,'\'                          ;start with '\'?
        je      loop4
        cmp     al,'/'                          ;start with '/'?
        je      loop4
        mov     byte ptr ds:[si],'\'            ;no, then put in delimiter
        inc     si                              ;(but not two consecutive)
loop4:
        mov     al,byte ptr es:[di]             ;get source byte
        mov     byte ptr ds:[si],al             ;put dest byte
        cmp     al,0
        je      loop5
        inc     si
        inc     di
        jmp     loop4                           ;loop until copied
loop5:
        mov     byte ptr ds:[si],13             ;put dest byte
        inc     si
        mov     byte ptr ds:[si],10             ;put dest byte
        inc     si
        mov     byte ptr ds:[si],0              ;put dest byte
        ret
mungfile endp

openfile proc near
; FILEN=filename
; Open file. Create it if missing.

        assume ds:nothing
; open the file
        mov     ax,cs
        mov     ds,ax           ;ds=code segment at interrupt time
        mov     dx,offset FILEN ;file name 0 terminated
        mov     al,2            ;read and write
        mov     ah,3dh          ;open file
        mov     si,offset fn    ;turn off ah=3dh trigger in newint21!
        mov     byte ptr ds:[si],0
        int     21h
        mov     bx,ax           ;bx=file handle
        mov     si,offset fn    ;turn on trigger again.
        mov     byte ptr ds:[si],1
        mov     ax,1            ;ax==1 means good open
        jnc     goodopen
        call    createfile
        mov     ax,1
        jnc     goodopen        ;bx=file handle
        mov     ax,0            ;ax==0 means bad open
goodopen:
        ret
openfile endp

createfile proc near                    ;create dir entry
         assume ds:nothing
        mov     ax,cs                   ;with current time stamp
        mov     ds,ax                   ;0 byte file (no space used)
        mov     cx,0                    ;file attributes
        mov     dx,offset FILEN         ;full path name to create
        mov     ah,03ch                 ;create file
        int     21h
        jc      createfileexit
        mov     bx,ax                   ;return bx=handle
createfileexit:
        ret
createfile endp

seekend proc near
        assume  ds:nothing
        push    dx
        push    bx
        mov     ax,cs
        mov     ds,ax
;       mov     bx,file handle
        mov     cx,0                    ;cx=high word
        mov     dx,0                    ;dx=low word of seek amount
        mov     al,2                    ;seek end of file
        mov     ah,42h                  ;set file pointer
        int     21h
        pop     bx
        pop     dx
        ret
seekend endp

writefile  proc near
        assume  ds:nothing
        mov     dx,offset path
        mov     ax,cs
        mov     ds,ax
;       mov     bx,file handle
        mov     cx,0                    ;cx=string length in bytes
        mov     si,dx
strlenloop:
        cmp     byte ptr ds:[si],0
        jz      strlenloopexit
        inc     cx
        inc     si
        jmp     strlenloop
strlenloopexit:
        mov     ah,40h
        int     21h                     ;write full path name to file
        ret
writefile endp

closefile proc near
        assume  ds:nothing
        mov     ah,3eh
;       mov     bx,file handle
        int     21h                     ;close file handle
        ret
closefile endp

;**************************************************************************
;resident portion above, temporary portion below
;**************************************************************************

               even
FILEN   db      '\freq.dat',0,'patch space patch space',0
BUFFER  db      0,0,0
path    db      'path name buffer area '
        db      'path name buffer area '
        db      'path name buffer area '
        db      'path name buffer area '
        db      'path name buffer area '
        db      'path name buffer area ',0
fn      db      1
stktop  dw      0
        dw      64 dup (0)
stkbot  dw      0       ;stack grows downward from here
;**************************************************************************
;temporary strings
mesg    db     'File use frequency TSR successfully installed'
        db      13,10
        db     'Collection file for DOS 3dh file opens is: ',0
mesg1   db     'File use frequency TSR already installed',0
;
printstring proc near
        assume ds:nothing
printloop:
        mov     al,byte ptr ds:[si]
        cmp     al,0
        je      printquit
        mov     dl,al
        mov     ah,2h
        int     21h
        inc     si
        jmp     printloop
printquit:
        ret
printstring endp

;
init    proc   near
        assume ds:cseg

        mov     ax,'fr'
        int     21h
        jc      success         ;tsr not loaded
        cmp     ax,'co'
        jne     success
        jmp     failed


;print a success message
success:
         mov    ax,cs
         mov    ds,ax
         mov    si,offset mesg  ;start of message to write
         call   printstring
         mov    si,offset FILEN
         call   printstring

;initialize location of WATCH stack
newstk: mov     ax,offset stkbot
        mov     newsp,ax
        mov     newss,cs        ;stack seg is code seg

;get int 21H vector
        cli
        mov    ax,3521H         ;GetVector DOS function call
        int    21H
        mov    old21,bx         ;store first word of old21
        mov    old21[2],es      ;store second word

;install the new vectors
        mov    ax,2521H
        mov    dx,offset newint21
        int    21H
        sti

;terminate and stay resident
        mov    ax,offset stkbot
        add    ax,15
        mov    cl,4
        shr    ax,cl
        mov    dx,ax
        mov    ax,3100H        ;return success code
        int    21H

failed:
        mov     ax,cs
        mov     ds,ax
        mov     si,offset mesg1 ;start of message to write
        call    printstring

        mov     ax,0
        int     21h
lastcode:
init    endp

Cseg    ends
        end     ComEntry
