TITLE	Exec Timer

; Execute a program, displaying start and end times.
; David Kirschbaum
; Toad Hall
; kirsch@braggvax.ARPA

AscMask	equ	2710H		; Asciifying mask
CR	equ	0DH
LF	equ	0AH

CSeg	SEGMENT	'CODE'
	ASSUME	CS:CSeg,DS:CSeg,ES:CSeg

	org	2CH
envaddr	dw	?				;Environment address

	org	80H				;PSP cmd line [TH]
PSPcmdline	db	?

	ORG	100H				; Program entry point

Timer	proc	far

	MOV	SP,OFFSET stack			; Set up local stack

	MOV	BX,OFFSET lastloc+15		; BX := program size in
	MOV	CX,4				;  paragraphs
	SHR	BX,CL				;memory requested in paras

	MOV	ah,4AH				; Deallocate unused memory
	INT	21H

	mov	ax,envaddr			;TH get environment addr
	MOV	parmblk,AX			;stuff in parameter block

	MOV	AX,CS				; Set segment registers
	MOV	parmblk+4,AX			;  in parameter block
	MOV	parmblk+8,AX			; to our Code Seg
	MOV	parmblk+12,AX

;TH move PSP command line into our own working buffer
	mov	si,offset PSPcmdline		;point to PSP cmd line
	mov	di,offset comline		;point to our own cmd line buff
	xor	ax,ax				;insure msb is clear
	cld					;insure fwd
	lodsb					;snarf cmd line length byte
	or	ax,ax				;anything there?
	je	NoCmd				; nope, use default
	mov	cx,ax				;into cx as a counter
;TH si now points to first char of PSP cmd line
	inc	ax				;+2 for '/C' already there
	inc	ax
	stosb					;force working cmd line len
	inc	di				;bump past "/C"
	inc	di
	rep	movsb				;transfer cmd line
NoCmd:
	call	Start_Time			;update time buffer
	mov	dx,offset StartMsg		;'Start: '
	mov	ah,9				;display string
	int	21H
	mov	dx,offset timebuff		;'hh:mm:ss.dd'
	mov	ah,9				;display string
	int	21H
;end of Toad Hall code

	MOV	DX,OFFSET filenam		; Set up exec call
	MOV	BX,OFFSET parmblk
	MOV	AX,4B00H			;DOS Exec function

	PUSH	DS				; Save machine state
	PUSH	ES
	mov	savess,SS			;TH
	mov	savesp,SP			;TH
	INT	21H				; Shell to DOS

;TH seem to recall something about disabling interrupts
; before fiddling these registers, but can't remember just what!
; Seems to work ok, so will leave it be for now.

	MOV	SP,CS:savesp			; Restore machine state
	MOV	SS,CS:savess
	POP	ES
	POP	DS

;more Toad Hall Code
	push	ax				;Save any program errorlevels
	cld					;insure still forward

	call	End_Time			;TH update time buffer
	mov	dx,offset EndMsg		;'Elapsed: hh:mm:ss.dd'
	mov	ah,9				;display string
	int	21H

	pop	ax				;restore EXEC program errors
	mov	ah,4CH				;terminate process
	int	21H
Timer	endp


TimeStuff	proc	near

End_Time:
	mov	ah,2CH				;get current time
	int	21H
;	mov	bl,deci				;old decisecond
;	mov	bh,sec				;old seconds
	mov	bx,startDX			;BL=deci,BH=sec
	mov	ah,60				;constant
	mov	al,dl				;get fraction
	sub	al,bl				;deci = dl-old deci
	jnb	S1				;no carry, so not <0
	 add	al,100				;<0, adjust
	 inc	bh				;bump old seconds
S1:	mov	dl,al				;save adj. deci

	mov	bl,min				;get old Minute
	mov	al,dh				;get new seconds
	sub	al,bh				;sec = new sec-old sec
	jnb	S2				;not <0
	 add	al,ah				;<0, add back 60
	 inc	bl				;old min=old min+1
	 jmp	short S3

S2:	cmp	al,ah				;>=60?
	jb	S3				; nope
	 sub	al,ah				; sec=sec-60
	 dec	bl				;old min=old min-1
S3:	mov	dh,al				;save adj. seconds

	mov	bh,hour				;old hour
	mov	al,cl				;get new minutes
	sub	al,bl				;min=new min-old min
	jnb	S4				; not below 0
	 add	al,ah				;min=min+60
	 inc	bh				;old hour=old hour+1
	 jmp	short S5

S4:	cmp	al,ah				;>=60?
	jb	S5				; nope
	 sub	al,ah				;min=min-60
	 dec	bh				;old hour=old hour-1
S5:	mov	cl,al				;save adj. minutes

	mov	al,ch				;get new hour
	sub	al,bh				;hour=new hour-old hour
	mov	ch,al

;We now have the time difference in CX and DX.
;Jump to stuff them into our time string and return.
	jmp	short Stuff_Time

Start_Time:
	mov	ah,2CH				;DOS get time svc
	int	21H
;	mov	hour,ch				;update globals
;	mov	min,cl
	mov	startCX,cx			;CL=min,CH=hour
;	mov	sec,dh
;	mov	deci,dl
	mov	startDX,dx			;DL=deci,DH=sec
;We have the start time in CX and DX.
; fall through to Stuff_Time and return

Stuff_Time:
;common procedure .. stuff time values in CX and DX
; into our time buffer (ASCII characters)
	mov	di,offset timebuff		;ES:DI

	xor	ax,ax				;insure msb is clear
	mov	bl,10				;div by 10
	mov	al,ch				;hours
	mov	bh,':'				;separator after hrs
	call	DoDiv

	mov	al,cl				;minutes
	call	DoDiv				;still ':' after minutes

	mov	al,dh				;seconds
	mov	bh,'.'				;decimal after seconds
	call	DoDiv

	mov	al,dl				;deci
	xor	bh,bh				;no divider
	call	DoDiv
	ret					;done

DoDiv:
	or	ax,ax				;divisor=0?
	jz	NoDiv				;yep
	 div	bl
NoDiv:
;quotient (10's) in al, remainder in ah
	add	ax,'00'				;asciify
	stosw
	or	bh,bh				;is it a zero?
	je	NoSep				; yep, no separator
	 mov	al,bh				;our separator
	 stosb
NoSep:
	xor	ax,ax				;clear msb again
	ret
TimeStuff	endp

startCX	label	word
min		db	0		;starting minutes
hour		db	0		;starting hours
startDX	label	word
deci		db	0		;starting decisecs
sec		db	0		;starting seconds

StartMsg	db	'Start: $'
EndMsg		db	'End: '
TimeBuff	db	'00:00:00.00'
		db	CR,LF,'$'

savess	DW	?				; Holders for SS:SP
savesp	DW	?

filenam	DB	'C:\COMMAND.COM',0		; Assume COMMAND.COM on C:

	Even					;TH for faster access?

parmblk	DW	00				; Parameter block
	DW	OFFSET comline,00
	DW	5CH,00
	DW	6CH,00

;TH default is just COMMAND.COM
comline	db	17				;TH default cmd length
	db	'/C C:\COMMAND.COM',CR		;TH default: Exec COMMAND.COM

COMLEN	=	$ - offset comline		;TH

	db	128-comlen DUP(0)		;TH up to 128 bytes

	DB	128  DUP (?)			; Stack
stack	LABEL	BYTE

lastloc	LABEL	BYTE				; End of program

CSeg	ENDS
	END	Timer
