	title	Toad825X
Comment ~
Author: David Kirschbaum 31 Aug 88
From "DMA Control on the PC"
by Larry Fogg, Micro Cornucopia #37, Sep-Oct 87

The article suggests a way to tweak the 8253 timer to slow down the RAM
refresh rate.  Author suggests you can slow the normal DREQ0 interrupt
from its normal 15-microsecond interval to up to a full second before RAM
will start failing.

Extract from the article's text:
     "It was right at one refresh every second that my RAM faded away.
A count of 900H loaded into the 8253's Timer 1 gives the one second
period.
     "The BIOS loads the count with 12H and the point of diminishing returns
comes around 30H or 40H.  After 40H refresh happens so infrequently as to
have no effect on system performance.  Benchmarks show no difference between
40H and 900H.
     "A value of 40H gives a 2.6% speed increase on my Holliston 186 board
and a 5.8% increase on a standard 4.77 MHz 8088.  I haven't had any problems
using this speedup.  But don't blame me if your machine dissolves into a
puddle of blue slime.  After all, we've gone beyond the limits of computer
decency."

Toad Hall Notes:
The author provided some assembler code to be used via DEBUG.
I rewrote it into a proper MASM-compatible .ASM format so you can compile
to REFRESH.COM (or whatever you wanna name it).  Run it on startup.
Returns the LSB as the DOS ERRORLEVEL (for what that's worth).
ERRORLEVEL of 1 means illegal entry, help, whatever.

Sure, I could write this to take the LSB from the DOS command line,
but that would only be for experimental use.  Better for you to determine
the "magic number" that's best for your system and just leave it hard-
coded.  That way no user will accidentally enter some weird number!

|v1.1 Command line entry is now allowed.  Use the original TOAD8253.ASM
|if you want to stick with the smaller program, hard-coded speed, etc.

I used the public domain MIPS.COM v1.10 CPU speed utility as a benchmark.
I also ran Norton's SYSINFO.COM (SI) utility just for comparisons.
The SI values vary irregularly on sequential runs (e.g., the 40H lsb
value produced SI ratings of 7.0 to 7.1).

Following are MIPS and SI results after running TOAD8253 with various
LSB values (and in the most extreme, a new MSB value).

				Counter 1 values
			12H	40H	80H	0A0H	0100H
General Instructions	0.48	0.50	0.51	0.51	0.51
Integer Instructions	0.87	0.90	0.90	0.91	0.91
Memory to Memory	0.69	0.74	0.75	0.76	0.76
Register to Register	1.13	1.14	1.15	1.15	1.15
Register to Memory	0.89	0.94	0.96	0.96	0.96
Performance Rating	0.81	0.85	0.85	0.86	0.86
Norton's SI rating	7.0	7.1	7.1	7.1	7.1

So, no significant changes after bumping the lsb to 0A0H or beyond.
(No, I did NOT push the timer to RAM memory failure!)

v1.1 SPEED.COM statistics:
"TOAD8253 18" (PC-DOS default):
	Checking memory block write   ticks: 126 compared to IBM/PC 400%
	Checking register to memory   ticks: 160 compared to IBM/PC 306%
	Checking memory to register   ticks: 196 compared to IBM/PC 250%
	Checking register to register ticks: 190 compared to IBM/PC 290%
	Checking divide by register   ticks:  78 compared to IBM/PC 656%
	Checking divide by memory     ticks: 116 compared to IBM/PC 520%
	Checking multiply by register ticks:  90 compared to IBM/PC 534%
	Checking multiply by memory   ticks: 114 compared to IBM/PC 488%
	Checking stack operations     ticks: 163 compared to IBM/PC 273%
	Checking far jumps, far calls ticks: 207 compared to IBM/PC 250%
  Total time is: 1440 clock ticks, (80 seconds) compared to IBM/PC 357%

"TOAD8253 160" (Optimum for my system):
	Checking memory block write   ticks: 118 compared to IBM/PC 427%
	Checking register to memory   ticks: 147 compared to IBM/PC 334%
	Checking memory to register   ticks: 177 compared to IBM/PC 276%
	Checking register to register ticks: 177 compared to IBM/PC 311%
	Checking divide by register   ticks:  77 compared to IBM/PC 664%
	Checking divide by memory     ticks: 112 compared to IBM/PC 539%
	Checking multiply by register ticks:  87 compared to IBM/PC 552%
	Checking multiply by memory   ticks: 104 compared to IBM/PC 535%
	Checking stack operations     ticks: 148 compared to IBM/PC 300%
	Checking far jumps, far calls ticks: 194 compared to IBM/PC 267%
  Total time is: 1341 clock ticks, (74 seconds) compared to IBM/PC 384%


Now, if you want to slow your system DOWN (not the original intention,
but some users need to slow down fast clones for games, etc.), here are
some slowdown stats:
					Counter 1 values
			10H	0AH	07H	05H	03H	02H	01H
General Instructions	0.47	0.44	0.39	0.38	0.26	0.23	LOCKUP!
Integer Instructions	0.87	0.84	0.83	0.77	0.63	0.57
Memory to Memory	0.68	0.63	0.59	0.54	0.33	0.35
Register to Register	1.11	1.09	1.01	1.01	0.81	0.81
Register to Memory	0.87	0.81	0.75	0.66	0.47	0.50
Performance Rating	0.80	0.76	0.71	0.67	0.50	0.49
Norton's SI rating:	6.6	6.6	6.3	6.2	4.4	4.6

My system is an older GulfStream 8MHz 80286 (XT-compatible, Phoenix ROM)
running PC-DOS 3.1.  Your mileage may vary.

Released to public domain.  PLEASE do not distribute this program without
its assembler source code and/or documentation!

David Kirschbaum
Toad Hall
kirsch@braggvax.ARPA

v1.1, 1 Sep 88
 - Added command line speed entry (2..2048 decimal), help.
 - more statistics from the PD utility SPEED.COM
 - Renamed TOAD825X.ASM to differ from hardcoded TOAD8253.ASM

Comment ends
~

CodeSeg	SEGMENT PUBLIC PARA 'Code'
	ASSUME	CS:CodeSeg, DS:CodeSeg, ES:CodeSeg

CR	EQU	0DH
LF	EQU	0AH
VALUE	EQU	00A0H		;TH optimum value, LSB=0AH, MSB=0
DEADRAM	EQU	800H		;Assume max RAM refresh delay
	org	100H


Toad8253	proc	near
	jmp	Start		;skip the data

usemsg	db 'TOAD825X - David Kirschbaum, Toad Hall, 1 Sep 88',CR,LF
	db "Adjust a PC's 8253 timer to change RAM refresh rate.",CR,LF
	db 'Usage  TOAD825X %',CR,LF
	db '  where % is a timer value value 2 (slowest) .. 2048.',CR,LF
	db 'PC-DOS normal delay value is 18,',CR,LF
	db 'optimum value for most systems is 64, 128, or 160.',CR,LF
	db 'A delay value over 2048 may lock up your system!',CR,LF,'$'
badmsg	db 'TOAD825X - Illegal timer value!',CR,LF
	db 'Range of 2 (slowest) .. 2048 (maximum) only!',CR,LF
	db '(TOAD825X ?  for help)',CR,LF,'$'
setmsg	db 'TOAD825X - 8253 timer reset.',CR,LF,'$'

Start:	call	Get_Rate		;get cmd line rate
	jc	No_Action		;CF means bad rate
	mov	al,74H			;configure 8253 (see Micro C #35, p.30)
	out	43H,al
	mov	al,bl			;counter 1 lsb from Get_Rate
	out	41H,al			;change counter 1 lsb to alter
					; refresh rate
	mov	al,bh			;counter 1 msb from Get_Rate
	out	41H,al
	mov	dx,offset setmsg	;'8253 timer reset'
	mov	ah,9			;DOS display string
	int	21H

No_Action:
	mov	al,bl			;return lsb as ERRORLEVEL
	mov	ah,4CH			;DOS terminate process
	int	21H

Toad8253	endp

Get_Rate	proc	near
	mov	si,81H			;DOS PSP cmd line buffer
	xor	ax,ax			;clear msb
	xor	bx,bx			;accumulate cmd line value in BX
	mov	cx,10			;*10 constant multiplier
	xor	dx,dx			;clear to flag overflow
Cmd_Loop:
	lodsb				;snarf cmd line char
	cmp	al,'?'			;user wants help?
	je	Usage			;yep, skip the rest
	cmp	al,0DH			;CR means done
	je	Cmd_Done
	cmp	al,' '			;gobble spaces
	je	Cmd_Loop
	cmp	al,'0'			;only 0..9 chars accepted
	jb	Cmd_Loop
	cmp	al,'9'
	ja	Cmd_Loop
;We have a legal digit
	sub	al,'0'			;deasciify the digit
;	or	bx,bx			;first time thru?
;	je	Ones			;Yep, no testing or MUL
;
	xchg	ax,bx			;swap, AX=prev value
	cmp	ax,DEADRAM		;max allowable timer value
	ja	Bad_Val			;illegal
	mul	cx			;old timer value * 10
	or	dx,dx			;any product > an integer is illegal
	jnz	Bad_Val			;illegal
	xchg	ax,bx			;bx=new timer value, AL=this digit,AH=0
;Ones:
	add	bx,ax			;add in new 1's
	jnc	Cmd_Loop		;CF means > an integer, illegal
Bad_Val:
	mov	dx,offset badmsg	;'Bad timer value'
	jmp	short Bad_Ret		;display msg, exit

Cmd_Done:
;total cmd line value has been accumulating in BX
	or	bx,bx			;no cmd line value at all?
	jz	Usage			;right, tell user how
	cmp	bx,2			;minimum timer value allowed
	jb	Bad_Val			;bad, return CF set
	cmp	bx,DEADRAM		;maximum timer value allowed
	ja	Bad_Val			;bad, return CF set
	clc				;CF clear means Ok
Cmd_Ret:
	ret

Usage:
	mov	dx,offset usemsg	;'TOAD825X changes...'
Bad_Ret:
	mov	ah,9			;DOS display str
	int	21H
	mov	bl,1			;ERRORLEVEL 1
	stc				;CF means no action
	ret
Get_Rate	endp

CodeSeg	ends
	end	Toad8253
