/* MS-DOS SHELL - Header File
 *
 * MS-DOS SHELL - Copyright (c) 1990,1,2 Data Logic Limited and Charles Forsyth
 *
 * This code is based on (in part) the shell program written by Charles
 * Forsyth and is subject to the following copyright restrictions:
 *
 * 1.  Redistribution and use in source and binary forms are permitted
 *     provided that the above copyright notice is duplicated in the
 *     source form and the copyright notice in file sh6.c is displayed
 *     on entry to the program.
 *
 * 2.  The sources (or parts thereof) or objects generated from the sources
 *     (or parts of sources) cannot be sold under any circumstances.
 *
 *    $Header: /usr/users/istewart/src/shell/sh2.1/RCS/sh.h,v 2.5 1992/12/14 10:54:56 istewart Exp $
 *
 *    $Log: sh.h,v $
 *	Revision 2.5  1992/12/14  10:54:56  istewart
 *	BETA 215 Fixes and 2.1 Release
 *
 *	Revision 2.4  1992/11/06  10:03:44  istewart
 *	214 Beta test updates
 *
 *	Revision 2.3  1992/09/03  18:54:45  istewart
 *	Beta 213 Updates
 *
 *	Revision 2.2  1992/07/16  14:33:34  istewart
 *	Beta 212 Baseline
 *
 *	Revision 2.1  1992/07/14  08:58:59  istewart
 *	211 Beta updates
 *
 *	Revision 2.0  1992/04/13  17:39:40  Ian_Stewartson
 *	MS-Shell 2.0 Baseline release
 *
 */

#define PATCHLEVEL		4
#define	LINE_MAX		1000	/* Command line length		*/
#define HISTORY_MAX		100	/* History array length		*/
					/* Space for full file name	*/
#define FFNAME_MAX		(PATH_MAX + NAME_MAX + 4)
#ifdef OS2
#define CMD_LINE_MAX		32000	/* Max command line length	*/
#else
#define CMD_LINE_MAX		127	/* Max command line length	*/
#endif
#define SSAVE_IO_SIZE		4	/* Save IO array malloc inc	*/
#define LEN_DEVICE_NAME_HEADER	5	/* /dev/ string length		*/

#define	NPUSH			8	/* limit to input nesting	*/

#define	NOFILE			20	/* Number of open files		*/
#define	NUFILE			10	/* # of user-accessible files	*/
#define	FDBASE			10	/* First file usable by Shell	*/

/*
 * Some characters
 */

#define CHAR_UNIX_DIRECTORY	'/'
#define CHAR_NEW_LINE		'\n'
#define CHAR_SINGLE_QUOTE	'\''
#define CHAR_DOUBLE_QUOTE	'"'
#define CHAR_BACKQUOTE		'`'
#define CHAR_RETURN		'\r'
#define CHAR_SPACE		' '
#define	CHAR_NOT		'^'
#define	CHAR_TAB		'\t'
#define	CHAR_XOR		'^'
#define CHAR_OPEN_PARATHENSIS	'('
#define CHAR_CLOSE_PARATHENSIS	')'
#define CHAR_OPEN_BRACES	'{'
#define CHAR_CLOSE_BRACES	'}'
#define CHAR_OPEN_BRACKETS	'['
#define CHAR_CLOSE_BRACKETS	']'
#define CHAR_TILDE		'~'


/* Here we introduce a new boolean value - MAYBE.  This is required for
 * a special case of the grave function
 */

#define MAYBE		(bool)(-1)

				/* Open in create mode			*/
#define O_CMASK		(O_WRONLY | O_CREAT | O_TRUNC | O_TEXT)
				/* Open in create mode for a pipe	*/
#define O_PMASK		(O_RDWR | O_CREAT | O_TRUNC | O_TEXT)
				/* Open in create mode for swap file	*/
#define O_SMASK		(O_RDWR | O_CREAT | O_TRUNC | O_BINARY)
#define O_SaMASK	(O_RDWR | O_BINARY)
#define O_RMASK		(O_RDONLY | O_NOINHERIT | O_TEXT)

/*
 * Path format conversion
 */

#define PATH_TO_UNIX(x)	ConvertPathToFormat ((x), '\\', CHAR_UNIX_DIRECTORY)
#define PATH_TO_DOS(x)	ConvertPathToFormat ((x), CHAR_UNIX_DIRECTORY, '\\')

/*
 * shell components
 */

#define	QUOTE		0200

#define	NOBLOCK		((C_Op *)NULL)
#define	NOWORD		((char *)NULL)
#define	NOWORDS		((char **)NULL)
#define	NOPIPE		(-1)

/*
 * Ignore Variables flags
 */

#define DISABLE_MAILCHECK	0x0001
#define DISABLE_OPTARG		0x0002
#define DISABLE_OPTIND		0x0004
#define DISABLE_SECONDS		0x0008
#define DISABLE_RANDOM		0x0010
#define DISABLE_LASTWORD	0x0020
#define DISABLE_LINECOUNT	0x0040

extern int	DisabledVariables;

/*
 * Result from FindLocationOfExecutable
 */

#define EXTENSION_NOT_FOUND	0	/* Cannot find file		*/
#define EXTENSION_EXECUTABLE	1	/* OS/2 or DOS .exe or .com	*/
#define EXTENSION_BATCH		2	/* OS/2 or DOS .cmd or .bat	*/
#define EXTENSION_SHELL_SCRIPT	3	/* Shell script			*/

/*
 * Description of a command or an operation on commands.
 * Might eventually use a union.
 */

typedef struct op {
    int			type;		/* operation type, see below	*/
    char		**words;	/* arguments to a command	*/
    struct ioword	**ioact;	/* IO actions (eg, < > >>)	*/
    struct op		*left;
    struct op		*right;
    char		*str;		/* identifier for case and for	*/
} C_Op;

#define	TCOM		1	/* command				*/
#define	TPAREN		2	/* (c-list)				*/
#define	TPIPE		3	/* a | b				*/
#define	TLIST		4	/* a [&;] b				*/
#define	TOR		5	/* ||					*/
#define	TAND		6	/* &&					*/
#define	TFOR		7	/* FOR					*/
#define	TDO		8	/* DO					*/
#define	TCASE		9	/* CASE					*/
#define	TIF		10	/* IF					*/
#define	TWHILE		11	/* WHILE				*/
#define	TUNTIL		12	/* UNTIL				*/
#define	TELIF		13	/* ELSE IF				*/
#define	TPAT		14	/* pattern in case			*/
#define	TBRACE		15	/* {c-list}				*/
#define	TASYNC		16	/* c &					*/
#define	TFUNC		17	/* c () {c-list}			*/
#define	TSELECT		18	/* SELECT				*/

/* Built in Command list */

struct	builtin {
    char	*command;
    int		(*fn)(int, char **);
    int		mode;
};

extern int	doexec (C_Op *);	/* Exec function a cheat	*/

/*
 * Valid values of mode
 */

#define BLT_ALWAYS	0x0001	/* Always use builtin version		*/
#define BLT_CURRENT	0x0002	/* Currently use builtin version	*/
#define BLT_NOGLOB	0x0004	/* No globbing for this internal	*/
#define BLT_CENVIRON	0x0008	/* Don't create a new environment	*/
#define BLT_NOWORDS	0x0010	/* Don't split words for this internal	*/
#define BLT_SKIPGLOB	(BLT_CURRENT | BLT_NOGLOB)
#define BLT_SKIPENVIR	(BLT_CURRENT | BLT_CENVIRON)

/*
 * actions determining the environment of a process
 */

#define	EXEC_WITHOUT_FORK	0x0001	/* execute without forking	*/
#define	EXEC_FUNCTION		0x0002	/* execute a function		*/
#ifdef OS2
#define	EXEC_SPAWN_NOWAIT	0x0004	/* execute a non-wait		*/
#define EXEC_SPAWN_DETACH	0x0008	/* execute a detach		*/
#define EXEC_SPAWN_IGNOREWAIT	0x0010	/* Pipe processing		*/
#endif

/* MSDOS Memory Control Block chain structure */

#ifndef OS2
#pragma pack (1)
struct MCB_list	{
    char		MCB_type;	/* M or Z			*/
    unsigned int	MCB_pid;	/* Process ID			*/
    unsigned int	MCB_len;	/* MCB length			*/
};
#pragma pack ()

#define MCB_CON		'M'		/* More MCB's			*/
#define MCB_END		'Z'		/* Last MCB's			*/
#endif

/* Externs for Swapper assembler function */

#ifndef OS2
extern char		cmd_line[];	/* Command line			*/
#endif
extern char		path_line[];	/* Process path			*/
extern unsigned int	SW_intr;	/* interrupt pending		*/
extern int		LastNumberBase;	/* Last base entered		*/

#ifndef OS2
extern bool		SW_poll;	/* Poll keyboard		*/
extern unsigned int	SW_Blocks;	/* Number of blocks to read	*/
extern unsigned int	SW_SBlocks;	/* Short Number of blocks to	*/
					/* read				*/
extern int		SW_fp;		/* File or EMS Handler		*/
extern int		SW_Pwrite;	/* Partial write to disk?	*/
extern unsigned long	SW_EMstart;	/* Start addr of extend mem	*/
extern unsigned int	SW_Mode;	/* Type of swapping to do	*/
					/* 1 - disk			*/
					/* 2 - Extended	memory		*/
					/* 3 - EMS Driver		*/
					/* 4 - XMS Driver		*/
extern unsigned int	SW_EMSFrame;	/* EMS Frame segment		*/

extern unsigned int	etext;		/* End of text segment		*/
extern int		Swap_Mode;	/* Swapping mode		*/

/* If you change these values, change sh7, swap_device as well */

#define SWAP_OFF	0x0000		/* No swapping			*/
#define SWAP_DISK	0x0001		/* Disk only			*/
#define SWAP_EXTEND	0x0002		/* Extended memory		*/
#define SWAP_EXPAND	0x0004		/* Expanded memory		*/
#endif

/*
 * flags to control evaluation of words
 */

#define	DOSUB		0x01	/* interpret $, `, and quotes		*/
#define	EXPAND_SPLITIFS	0x02	/* Perform blank interpretation		*/
#define	EXPAND_GLOBBING	0x04	/* Do globbing on name			*/
#define	EXPAND_MOVE	0x08	/* move words with `=' to 2nd arg. list */
#define	DOTRIM		0x10	/* trim resulting string		*/
#define	EXPAND_CONVERT	0x20	/* Convert - and / to DOS format	*/

#define	EXPAND_ALL	(DOSUB | EXPAND_SPLITIFS | EXPAND_GLOBBING |	\
			 EXPAND_MOVE | DOTRIM)

extern char		**ParameterArray;/* $<numeric> values		*/
extern int		ParameterCount;	/* $<numeric> count		*/
extern int		ExitStatus;
extern bool		ExpansionErrorDetected;
extern bool		InteractiveFlag;/* interactive			*/
extern bool		ProcessingEXECCommand;
extern int		AllowMultipleLines;	/* Allow continuation	*/
extern int		*FailReturnPoint;
extern int		*ErrorReturnPoint;
extern bool		InParser;	/* In parser flag		*/
extern int		Current_Event;	/* Current history event	*/
extern bool		ChangeInitLoad;	/* Change load .ini point.	*/

/*
 * Break/Continue (in for and while), Return and Exit handler
 */

typedef struct brkcon {
    jmp_buf		CurrentReturnPoint;
    struct brkcon	*NextExitLevel;
} Break_C;
				/* Values returned by longjmp		*/
#define BC_LOAD		0	/* Load condition			*/
#define BC_BREAK	1	/* Break condition			*/
#define BC_CONTINUE	2	/* Continue condition			*/

extern Break_C	*Break_List;	/* Break list for FOR/WHILE		*/
extern Break_C	*Return_List;	/* Return list for RETURN		*/
extern Break_C	*SShell_List;	/* SubShell list for EXIT		*/
extern bool	RestrictedShellFlag;	/* Read only shell		*/
extern bool	HistoryEnabled;

/*
 * Word List structure
 */

typedef struct wdblock {
    short	w_bsize;
    short	w_nword;
    char	*w_words[1];
} Word_B;

extern Word_B	*WordListBlock;
extern Word_B	*IOActionBlock;

/*
 * Save Standard Input/Output/Error structure
 */

typedef struct save_io {
    int		depth;			/* Execute recursive depth	*/
    int		fp[STDERR_FILENO + 1];	/* File handlers		*/
} Save_IO;

extern Save_IO	*SSave_IO;		/* Save IO array		*/
extern int	NSave_IO_E;		/* Number of entries		*/
extern int	MSave_IO_E;		/* Max Number of entries	*/

/*
 * Function tree processing
 */

typedef struct FunctionList {
    C_Op		*tree;		/* The tree itself		*/
    bool		Traced;		/* Traced flag			*/
} FunctionList;

extern void		*FunctionTree;	/* Function Tree root		*/
extern FunctionList	*CurrentFunction;

/*
 * Alias processing
 */

typedef struct AliasList {
    char		*name;		/* The alias name		*/
    char		*value;		/* The alias			*/
    bool		Tracked;	/* Tracked Alias		*/
} AliasList;

extern void		*AliasTree;	/* Alias Tree root		*/

/*
 * Job Processing
 */

#ifdef OS2
typedef struct JobList {
    int			Number;		/* Current number		*/
    PID			pid;		/* Process ID 			*/
    char		*Command;	/* Program			*/
} JobList;

extern void		*JobTree;	/* Job Tree root		*/
extern bool		ExitWithJobsActive;	/* Exit flag		*/
extern int		CurrentJob;		/* No current		*/
extern int		PreviousJob;		/* Previous Job		*/
#endif

/*
 * redirection
 */

typedef struct ioword {
    short	io_unit;	/* unit affected			*/
    short	io_flag;	/* action (below)			*/
    char	*io_name;	/* file name				*/
} IO_Actions;

#define	IOREAD		0x0001	/* <					*/
#define	IOHERE		0x0002	/* << (here file)			*/
#define	IOWRITE		0x0004	/* >					*/
#define	IOCAT		0x0008	/* >>					*/
#define	IOXHERE		0x0010	/* ${}, ` in <<				*/
#define	IODUP		0x0020	/* >&digit				*/
#define	IOCLOSE		0x0040	/* >&-					*/
#define	IOTHERE		0x0080	/* <<- (here file			*/
#define	IOCLOBBER	0x0100	/* >| overwrite noclobber		*/

#define	IODEFAULT	(-1)	/* token for default IO unit		*/

/*
 * parsing & execution environment
 */

typedef struct env {
    char	*cline;			/* Current line buffer		*/
    char	*linep;			/* Current pointer in line	*/
    char	*eline;			/* End of line pointer		*/
    struct io	*iobase;
    struct io	*iop;
    int		*ErrorReturnPoint;
    bool	eof_p;			/* EOF processing enabled	*/
    int		FirstAvailableFileHandler;
    Word_B	*GlobbingFileList;
    struct env	*oenv;			/* Previous environment		*/
} ShellFileEnvironment;

extern ShellFileEnvironment		e;

/*
 * flags:
 *
 * -a: Set all environment variables to exported
 * -e: Quit on error
 * -f: Disable file name expansion
 * -k: Look for name=value everywhere on command line
 * -n: No execution
 * -t: exit after reading and executing one command
 * -u: Abort if environment variable is not set
 * -v: Echo as read
 * -x: Trace
 */

#define FL_TEST(x)	(flags & (1L << ((x) - 'a')))
#define FL_SET(x)	flags |= (1L << ((x) - 'a'))
#define FL_CLEAR(x)	flags &= (~(1L << ((x) - 'a')))

extern long	flags;

/*
 * Global flags set by set -o which do not have single letter equivalents
 */

extern unsigned char	GlobalFlags;

#define FLAGS_NONE		0x00
#define FLAGS_IGNOREEOF		0x01	/* Ignore EOF			*/
#define FLAGS_MARKDIRECTORY	0x02	/* Mark directories with /	*/
#define FLAGS_NOCLOBER		0x04	/* No delete on existing files	*/
#define FLAGS_FUNCTION		0x08	/* Special value used in	*/
					/* CreateGlobalVariableList.	*/
					/* Indicates a function caused  */
					/* CGVL to be called. Not used	*/
					/* otherwise			*/
#define FLAGS_REALPIPES		0x10	/* Use Real pipes under OS/2	*/

extern char	null[];		/* null value for variable		*/
extern int	InterruptTrapPending;	/* trap pending			*/
extern int	Execute_stack_depth;	/* execute function recursion	*/
					/* depth			*/

/*
 * Mode values for new GeneralPatternMatch
 */

#define GM_ALL		0		/* Match full string		*/
#define GM_SHORTEST	1		/* Shortest prefix/suffix	*/
#define GM_LONGEST	2		/* Longest prefix/suffix	*/

/*
 * Variable list
 */

typedef struct var {
    char		*name;		/* Name				*/
    char		*value;		/* Value			*/
    unsigned long	nvalue;		/* Numeric value		*/
    unsigned int	base;		/* Numeric base			*/
    unsigned int	width;		/* Field width			*/
    unsigned int	status;		/* Type, see below		*/
} VariableList;

#define	STATUS_READONLY		0x0001	/* variable is read-only	*/
#define	STATUS_EXPORT		0x0002	/* variable is to be exported	*/
#define STATUS_CANNOT_UNSET	0x0008	/* PATH Value - no unset	*/
#define STATUS_CONVERT_MSDOS	0x0010	/* Convert to MSDOS format	*/
#define STATUS_LEFT_JUSTIFY	0x0020	/* Left Justify			*/
#define STATUS_RIGHT_JUSTIFY	0x0040	/* Right Justify		*/
#define STATUS_ZERO_FILL	0x0080	/* Zero fill			*/
#define STATUS_LOWER_CASE	0x0100	/* Convert to lower case	*/
#define STATUS_UPPER_CASE	0x0200	/* Convert to upper case	*/
#define STATUS_INTEGER		0x0400	/* Contains integer value	*/
#define STATUS_TAGGED		0x0800	/* User tagged			*/
#define STATUS_LOCAL		0x1000	/* Local variable in function	*/
#define STATUS_NOEXISTANT	0x8000	/* Does not exist		*/

extern void		*VariableTree;		/* Variable dictionary	*/
extern VariableList	*CurrentDirectory;	/* Current directory	*/
extern char	PS1[];			/* Prompt 1			*/
extern char	PS2[];			/* Prompt 2			*/
extern char	PS3[];			/* Prompt 3			*/
extern char	PS4[];			/* Prompt 4			*/
extern char	IFS[];			/* Interfield separators	*/
extern char	*LastUserPrompt;	/* Last prompt output		*/
extern char	*LastUserPrompt1;	/* Alternate prompt output	*/
extern char	PathLiteral[];		/* PATH Variable		*/
extern char	HomeVariableName[];	/* Home Variable		*/
extern char	ShellVariableName[];	/* Shell Variable		*/
extern char	*ParameterCountVariable;/* Parameter Count Variable (#)	*/
extern char	*ShellOptionsVariable;	/* Shell Options Variable (-)	*/
extern char	*StatusVariable;	/* Status variable (?)		*/
extern char	*ComspecVariable;	/* COMSPEC string		*/
extern char	*spcl2;
extern char	SecondsVariable[];	/* Seconds string		*/
extern char	RandomVariable[];	/* Random string		*/
extern char	LineCountVariable[];	/* LINENO string		*/
extern char	*OldPWDVariable;	/* OLDPWD string		*/
extern char	*PWDVariable;		/* PWD string			*/
extern char	*ENVVariable;		/* ENV string			*/
extern char	BATExtension[];		/* .bat string			*/
extern char	SHELLExtension[];	/* .sh string			*/
extern char	EXEExtension[];		/* .exe string			*/
extern char	COMExtension[];		/* .com string			*/
extern char	HistoryFileVariable[];	/* HISTFILE string		*/
extern char	HistorySizeVariable[];	/* HISTSIZE string		*/
extern bool	FirstReadFromUser;	/* First Time I/O from user	*/
extern bool	UseConsoleBuffer;	/* Flag from dofc to		*/
					/* GetConsoleInput		*/
extern char	*NotFound;		/* Not found message		*/
extern char	*BasicErrorMessage;	/* Basic error message		*/
extern char	*DirectorySeparator;	/* Directory separator		*/
extern char	*DeviceNameHeader;	/* /dev/			*/
extern char	LastWordVariable[];	/* Last word of command variable*/
extern char	OptArgVariable[];	/* OPTARG			*/
extern char	OptIndVariable[];	/* OPTIND			*/
extern char	MailCheckVariable[];	/* MAILCHECK			*/
extern char	*Trap_DEBUG;		/* DEBUG trap variable		*/
extern char	*Trap_ERR;		/* ERR trap variable		*/
extern char	ConsoleLineBuffer[];	/* Console line buffer		*/
extern char	LIT_export[];		/* export literal		*/
extern char	LIT_history[];		/* history literal		*/
extern char	LIT_REPLY[];		/* Reply literal		*/
extern char	LIT_exit[];		/* Exit literal			*/
extern char	LIT_exec[];		/* Exec literal			*/
extern char	LIT_LINES[];		/* LINES literal		*/
extern char	LIT_COLUMNS[];		/* COLUMNS literal		*/
extern char	*LIT_2Strings;		/* 2 String concat		*/
extern char	*LIT_3Strings;		/* 3 string concat		*/
extern char	*ListVarFormat;		/* List variable format		*/
extern char	*Outofmemory1;		/* Out of memory string		*/
extern char	*LIT_Emsg;		/* Error message format		*/

#ifdef OS2
extern void	SetWindowName (void);	/* Set the Window Name		*/
extern STARTDATA *SessionControlBlock;	/* Start a session info		*/
#endif

/*
 * SubShell Save Structure
 */

typedef struct subshell {
    int			depth;		/* Sub_Shell Depth		*/
    unsigned char	GFlags;		/* Global flags			*/
    long		Eflags;		/* single letter flags		*/
    void		*OldVariableTree;	/* Header start		*/
} S_SubShell;

extern S_SubShell	*SubShells;	/* Save Vars array		*/
extern int		NSubShells;	/* Number of entries		*/
extern int		MSubShells;	/* Max Number of entries	*/

/* io buffer */

typedef struct iobuf {
    unsigned int	id;		/* buffer id			*/
    char		buf[512];	/* buffer			*/
    char		*bufp;		/* pointer into buffer		*/
    char		*ebufp;		/* pointer to end of buffer	*/
} IO_Buf;

/* possible arguments to an IO function */

typedef struct ioarg {
    char		*aword;
    char		**awordlist;
    int			afile;		/* file descriptor		*/
    unsigned int	afid;		/* buffer id			*/
    long		afpos;		/* file position		*/
    int			afoff;		/* Offset in buffer		*/
    IO_Buf		*afbuf;		/* buffer for this file		*/
} IO_Args;

#define AFID_NOBUF	(~0)
#define AFID_ID		0

extern IO_Args	ioargstack[NPUSH];	/* IO argument stack		*/

/* an input generator's state */

typedef struct io {
    int			(*iofn)(struct io *);
    IO_Args		*argp;
    unsigned int	LineCount;	/* Line Count			*/
    char		*FileName;	/* File name			*/
    int			PeekedChar;	/* Current returned character	*/
    char		PreviousChar;	/* Previous character read by	*/
					/* ReadCharacterFromIOStack()	*/
    char		NewLineCount;		/* for `'s		*/
    char		NextNonNLCharacter;	/* for `'s		*/
    char		TaskType;	/* reason for pushed IO		*/
					/* Special processing flag for	*/
					/* $* and $@			*/
    char		StarAmpersandProcessing;
} IO_State;

/*
 * StarAmpersandProcessing values
 */

#define DSA_NULL	0x00		/* No special processing req	*/
#define DSA_STAR	0x01		/* Special processing for "$*"	*/
#define DSA_AMP		0x02		/* Special processing for "$@"	*/
#define DSA_MODE	0x03		/* Mode flag			*/
#define DSA_END		0x04		/* Last word processing		*/
#define DSA_START	0x08		/* First word processed?	*/
#define DSA_START1	0x10		/* Subsequent word processed	*/
#define DSA_END1	0x20		/* End processing for word	*/

extern IO_State		iostack[NPUSH];	/* IO Stack			*/

/*
 * Responses from IOStackPosition () and IOBasePosition ();
 */

#define IOSTACK_FIRST	0x01		/* First entry			*/
#define IOSTACK_INSIDE	0x02		/* Inside, excluding first	*/
#define IOSTACK_OUTSIDE	0x04		/* Outside			*/

/*
 * TaskType values
 */

#define	X_ANYOTHER_IO	0x00		/* none of the below		*/
#define	X_EXPAND_DOLLAR	0x01		/* expanding ${}		*/
#define	X_FROM_STDOUT	0x02		/* expanding `'s		*/
#define	X_FILE_IO	0x03		/* file IO			*/
#define	XRESET_RF	0x40		/* Reset -r option		*/
#define	XRESET_XF	0x80		/* Reset -x option		*/

#define XGetTaskType()	(e.iop->TaskType & 0x0f)

/* In substitution */

#define	INSUB()		(XGetTaskType () == X_FROM_STDOUT ||		\
			 XGetTaskType () == X_EXPAND_DOLLAR)

/*
 * IO control
 */

extern IO_Args		temparg;	/* temporary for PUSHIO */

#define	PUSHIO(what, arg, gen, file)					\
			((temparg.what = (arg)),			\
			 AddToIOStack (&temparg, (gen), (file)))

#define	RUN(what, arg, gen, loop, file, params)				\
			((temparg.what = (arg)),			\
			 RunGeneratorCommand (&temparg, (gen), loop,	\
					      file, params))

/*
 * Extract field from a line
 */

typedef struct Fields {
    FILE	*FP;			/* File handler			*/
    char	*Line;			/* Line buffer			*/
    int		LineLength;		/* Line Length			*/
    Word_B	*Fields;	/* ptr to the start of fields	*/
} LineFields;

extern int	ExtractFieldsFromLine (LineFields *);
extern Word_B	*SplitString (char *, Word_B *);

/*
 * Type of processing required by executable program.
 */

struct ExecutableProcessing {
    char		*Name;
    unsigned int	Flags;
    unsigned char	FieldSep;
};

extern void	CheckProgramMode (char *, struct ExecutableProcessing *);
					/* Current executable mode	*/
extern struct ExecutableProcessing 	ExecProcessingMode;

/* Flags set a bit to indicate program mode */

#define EP_NONE		0x000		/* Use PSP command line		*/
#define EP_DOSMODE	0x001		/* Use DOS mode extended line	*/
#define EP_UNIXMODE	0x002		/* Use UNIX mode extended line	*/
#define EP_NOEXPAND	0x004		/* Use -f for this command	*/
#define EP_ENVIRON	0x008		/* Use environ for variable	*/
#define EP_NOSWAP	0x010		/* Do not swap for this command	*/
#define EP_EXPORT	0x040		/* Use -m for this command	*/
#define EP_CONVERT	0x080		/* Use conversion		*/
#define EP_NOWORDS	0x100		/* Do word expansion		*/

/*
 * storage allocation
 */

extern int	MemoryAreaLevel;	/* current allocation area */

/* Functions */

extern void	main (int, char **);

extern void	ShellErrorMessage (char *, ...);
extern void	PrintErrorMessage (char *, ...);
extern int	PrintWarningMessage (char *, ...);

extern void	ExitTheShell (bool);

extern void	TerminateCurrentEnvironment (void);
extern bool	CreateNewEnvironment (int);
extern void	QuitCurrentEnvironment (void);

extern void	InterruptSignalled (int);
extern void	TerminateSignalled (int);
extern void	RunTrapCommand (int);

extern void	SetShellSwitches (void);
extern Word_B	*AddWordToBlock (char *, Word_B *);
extern char	**GetWordList (Word_B *);
extern char	*IntegerToString (int);
extern char	*GenerateTemporaryFileName (void);
extern int	(*IsCommandBuiltIn (char *, int *))();
extern char	*BuildNextFullPathName (char *, char *, char *);
extern int	LookUpSymbol (char *);
extern int	GetNumericValue (char *);
extern bool	ConvertNumericValue (char *, long *, int);
extern char	*BuildFileName (char *);
extern int	CreateGlobalVariableList (unsigned char);
extern void	DeleteGlobalVariableList (void);
extern Word_B	*AddParameter (char *, Word_B *, char *);

extern int	RestoreStandardIO (int, bool);
extern void	RestoreCurrentDirectory (char *);
extern void	RestoreEnvironment (int, int);
extern bool	CheckForRestrictedShell (char *);
extern void	OutputUserPrompt (char *);
extern void	DisplayLineWithControl (char *);
extern void	GetCurrentDirectory (void);
extern int	OpenForExecution (char *, char **, int *);
extern bool	AddToStackForExection (char *);
extern char	**BuildCommandEnvironment (void);
extern int	ProcessOutputMetaCharacters (char **);
extern char	*ConvertPathToFormat (char *, char, char);
extern int	CheckForScriptFile (char *, char **, int *);
extern void	PrintVersionNumber (FILE *);
#ifndef OS2
extern void	ClearSwapFile (void);
#endif
extern void	ClearExtendedLineFile (void);

extern bool	GeneralPatternMatch (char *, char *, bool, char **, int);
extern bool	SuffixPatternMatch (char *, char *, char **, int);
extern bool	any (char, char *);
extern bool	anys (char *, char *);
extern int	_GP_SortCompare	(char **, char **);
extern int	CountNumberArguments (char **);

extern long	EvaluateMathsExpression (char *);
extern bool	ValidMathsExpression (char *, long *);

extern C_Op	*BuildParseTree (void);
extern int	ExecuteParseTree (C_Op *, int, int, int);
extern int	RunGeneratorCommand (IO_Args *, int (*)(IO_State *), bool,
				     char *, char **);
#ifndef OS2
extern int	SA_spawn (char **);
#endif
extern int	ExecuteACommand (char **, int);
extern int	FindLocationOfExecutable (char *, char *);

extern int	GetNextCharacter (int);
extern void	ReturnGotCharacter (int);
extern int	ReadCharacterFromIOStack (void);
extern bool	CheckForEndOfFile (void);
extern void	AddToIOStack (IO_Args *, int (*)(IO_State *), char *);
extern int	CloseUpIOStack (IO_State *, bool);
extern int	ReMapIOHandler (int);
extern int	IOStackPosition (int);
extern int	IOBasePosition (void);

extern char	**eval (char **, int, struct ExecutableProcessing *);
extern char	*evalstr (char *, int);
extern int	subgetc (char, bool);

extern bool	ChangeInitialisationValue (char *, int);
extern void	Configure_Keys (void);

/*
 * Keyboard Input
 */

#ifndef OS2
extern int	Read_Keyboard (void);
#endif
extern void	PositionCursorInColumnZero (void);
extern int	GetConsoleInput (IO_Args *);
extern bool	Interactive (void);
extern int	CollectInputToCharacter (int, int);
extern bool	IsConsole (int);
extern bool	IsDirectory (char *);
extern int	GetEOFKey (void);

#ifndef NO_HISTORY
extern void	GetLineFromConsole (void);
#endif

/*
 * Valid values to ScanForEndofWord
 */

#define SWT_STDOUT	0		/* $(...)			*/
#define SWT_EVARIABLE	1		/* ${...}			*/
#define SWT_LET		2		/* ((....))			*/
#define SWT_CONDITIONAL	3		/* [[....]]			*/
#define SWT_EXPRESSION	4		/* $((....))			*/

extern int	ScanForEndofWord (int, int);

/*
 * Variable Name functions
 */

extern void		UnSetVariable (char *, bool);
extern void		SetVariableStatus (char *, int);
extern void		ClearVariableStatus (char *, int);
extern char		*GetVariableAsString (char *, bool);
extern long		GetVariableAsNumeric (char *);
extern void		SetVariableFromString (char *, char *);
extern void		SetVariableFromNumeric (char *, long);
extern void		HandleSECONDandRANDOM (void);
extern bool		AssignVariableFromString (char *);
extern char		IsValidVariableName (char *);
extern bool		IsVariableAssignment (char *);
extern VariableList	*LookUpVariable (char *, bool);
extern int		FindVariable (void *, void *);

/*
 * Underlying Get Next Character functions
 */

extern int		Line_GetNextCharacter (IO_State *);
extern int		WordList_GetNextCharacter (IO_State *);
extern int		SpacedWordList_GetNextCharacter (IO_State *);
extern int		String_GetNextCharacter (IO_State *);
extern int		QuotedString_GetNextCharacter (IO_State *);
extern int		File_GetNextCharacter (IO_State *);
extern int		NonNLStdOut_GetNextCharacter (IO_State *);
extern int		StdOut_GetNextCharacter (IO_State *);
extern int		NonQuoteSO_GetNextCharacter (IO_State *);
extern int		FileLine_GetNextCharacter (IO_State *);

/*
 * Memory management
 */

extern char		*AllocateMemoryCell (size_t);
extern void		ReleaseMemoryCell (void *);
extern void		ReleaseMemoryArea (int);
extern void		SetMemoryAreaNumber (void *, int);
extern int		GetMemoryAreaNumber (void *);
extern char		*GetAllocatedSpace (size_t);
extern char		*StringSave (char *);
extern char		*StringCopy (char *);
#ifdef DEBUG_MEMORY
extern void		DumpMemoryCells (int);
#define exit(x)		DumpMemoryCells (x)
#endif

/*
 * Here file processing
 */

extern void		SaveHereFileInfo (char *, IO_Actions *);
extern void		GetAllHereFiles (void);
extern int		OpenHereFile (char *, int);
extern void		ScrapHereList (void);
extern void		FreeAllHereFiles (int);

/*
 * UNIX File I/O function emulation
 */

extern int		S_open (bool, char *, int, ...);
extern int		S_close (int, bool);
extern int		S_dup (int);
extern int		S_dup2 (int, int);
extern int		S_Remap (int, int);
extern void		S_Delete (int);
extern int		OpenAPipe (void);
extern void		CloseThePipe (int);
extern void		CloseAllHandlers (void);
extern unsigned int	GetCurrentDrive (void);
extern unsigned int	SetCurrentDrive (unsigned int);
extern bool		SetUpIOHandlers (IO_Actions *, int, int);
extern int		GetRootDiskDrive (void);
extern char		*CheckDOSFileName (char *);

/*
 * Shell Functions
 */

extern FunctionList	*LookUpFunction (char *);
extern bool		SaveFunction (C_Op *);
extern void		DeleteFunction (C_Op *);
extern void		PrintFunction (C_Op *);
extern C_Op		*CopyFunction (C_Op *);
extern int		PrintAllFunctions (void);

/*
 * Alias processing
 */

extern AliasList	*LookUpAlias (char *, bool);
extern void		DeleteAlias (char *);
extern bool		SaveAlias (char *, char *, bool);
extern void		PrintAlias (char *);
extern bool		IsValidAliasName (char *, bool);
extern void		UnTrackAllAliases (void);
extern int		PrintAllAlias (bool);

/*
 * Job Processing
 */

#ifdef OS2
extern int		AddNewJob (PID pid, char *command);
extern void		DeleteJob (PID);
extern int		PrintJobs (bool);
extern int		NumberOfActiveJobs (void);
extern JobList		*LookUpJob (int);
extern JobList		*SearchForJob (char *);
extern int		PrintProcessTree (pid_t);
#endif

/*
 * History Processing
 */

extern void		AddHistory (bool);
extern void		LoadHistory (void);
extern void		DumpHistory (void);
extern void		ClearHistory (void);
extern void		PrintHistory (bool, bool, int, int, FILE *);
extern int		GetLastHistoryEvent (void);
extern int		SearchHistory (char *);
extern void		FlushHistoryBuffer (void);
extern void		DeleteLastHistory (void);
extern char		*GetLastHistoryString (void);

/*
 * Interrupt handling
 */

#ifndef OS2
extern void interrupt	SW_Int24 (void);	/* Int 24 New address	*/
extern void interrupt	SW_Int23 (void);	/* Int 23 New address	*/
extern void interrupt	SW_Int00 (void);	/* Int 00 New address	*/
extern bool		SW_I23_InShell;		/* In the shell		*/
#endif

/*
 * XMS Driver functions
 */

#ifndef OS2
extern void (far *SW_XMS_Driver) (void);	/* XMS Driver Interface	*/
extern int		SW_XMS_Gversion (void);
extern int		SW_XMS_Allocate (unsigned int);
extern int		SW_XMS_Free (int);
extern int		SW_XMS_Available (void);
#endif

/*
 * Modified getopt for shell
 */

extern int		OptionIndex;		/* optind		*/
extern int		OptionStart;		/* start character	*/
extern char		*OptionArgument;	/* optarg		*/

extern int		GetOptions (int, char **, char *, int);

/*
 * Save structure for getopts command
 */

typedef struct GetoptsIndex {
    int		Index;
    int		SubIndex;
} GetoptsIndex;

extern void		ResetGetoptsValues (bool);
extern void		GetGetoptsValues (GetoptsIndex *);
extern void		SaveGetoptsValues (int, int);

/*
 * General Functions
 */


/*
 * Flag values
 */

#define GETOPT_PLUS	0x01		/* Allow plus sign		*/
#define GETOPT_MESSAGE	0x02		/* Print error message		*/
#define GETOPT_PRINT	0x04		/* doecho special		*/

/*
 * TSEARCH Functions
 */

typedef enum { preorder, postorder, endorder, leaf }	VISIT;

/*
 * Tree functions
 */

extern void	*tsearch (void *, void **, int (*)(const void *, const void *));
extern void	*tfind (void *, void **, int (*)(const void *, const void *));
extern void	*tdelete (void *, void **, int (*)(const void *, const void *));
extern void	twalk (const void *, void (*)(const void *, VISIT, int));
