
; Program	: DTROFF.ASM
; Author	: Gary Conway, Infinity Design Concepts, Inc.
; Created	: 5/27/88
; Format	: COM file

; This program accepts a command line argument that is the COM port number
; The DTR line will be dropped for this com port.
; If no command line argument is given, then no action is taken
; usage:   DTROFF 1     -- this would drop DTR on port 1

Main		Segment
		Assume CS:main,DS:main,DS:main,SS:main
		Org	100h
				
Start:		Cld
		Mov	CX,80		; max search length
		Mov	SI,82h		; command line parms start here
FindCmd:	Dec	CX		; decr counter
		Jcxz	Exit		; nothing found
		Lodsb			; get command line argument
		Cmp	AL,13		; end of string ?
		Jz	Exit		; yeah, get outta here
		Cmp	AL," "		; skip blanks
		Jz	FindCmd
		
		Sub	AL,"1"		; make it binary
		Cbw			; make it a word
		Mov	[ComPort],AX	; save it
		Call	GetBase		; calculate base address of comport
		Call	Comoff		; drop DTR
Exit:		Mov	AX,4C00h
		Int	21h		; exit to DOS
	
ComOFF		Proc
		Mov	DX,[BaseAddress]
		Add	DX,4		; point to modem control register
		Mov	AL,0		; clear DTR and DSR
		Out	DX,AL
		Ret		
ComOFF		Endp


GetBase		Proc
		Mov	DI,[ComPort]	; 0 = COM 1, 1 = COM 2
		Add	DI,DI
		Push	ES
		Mov	AX,40h		; BIOS com segment
		Mov	ES,AX
		Mov	DX,ES:[DI]
		Pop	ES
		Mov	[BaseAddress],DX
		Ret
GetBase		Endp

; turn DTR on, on the modem

DTR_ON		Proc
		Mov	DX,[BaseAddress]
		Add	DX,4		; point to modem control reg.
		Mov	AL,1		; turn on bit 1 (DTR)
		Out	DX,AL
		Ret
DTR_ON		Endp

ComPort		DW	0
BaseAddress	DW	0
Main		Ends
		End	Start
