//
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// $Workfile:   ffctl.c  $
// $Revision:   1.0  $
//   $Author:   Doc  $
//  $Modtime:   09 Feb 1992 07:23:20  $
//      $Log:   D:/CR/ADK/VCS/FFCTL.C_V  $
// 
//    Rev 1.0   09 Feb 1992 07:24:02   Doc
// Initial revision.
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//
//  Simple control utility for FastFlip v2.15
//  Compiled with Borland C++ v2.0
//  Should compile with TurboC (any version) and that "other" compiler
//
//  This util uses the multiplex interface to communicate with FastFlip.
//  See "Microsoft Encyclopedia" (or another DOS reference) for a detailed
//  discussion of the multiplex interrupt.
//
//  FastFlip uses an mpx id of hex 92.
//
//  -----------------------------------------------------------------------
//

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <ff.h>

#define   byte  unsigned char
#define   word  unsigned int


int  DoArgs(char *argv[],                    //command line
            char Sw,                         //switch char
            char *ArgStrs[],                 //static arg triggers
            void(*call)(char *s,int f));     //function to call on trigger

//
//------------------------------------------------------------------------
//
//------------------------------------------------------------------------
//
void DoUsage(void)
{
  puts("\a\n"
       "USAGE: FFCTL <option>\n\n"
       "       -L    Lock\n"
       "       -U    Unlock\n"
       "       -P#   Goto page #\n"
       "       -T#   Set timer to # clicks\n");
  exit (9);
}


//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
void _ArgProc(char *s, int FlagChr)
{
  int   i;
  int   page;
  int   maxpages;

  if (FlagChr < 256)
    FlagChr = toupper(FlagChr);

  switch(FlagChr)                                   //
  {                                                 //
    case 'L':                                       //lock
      ffSetLock(1);                                 //
      puts("FastFlip locked");                      //
      break;                                        //
    case 'U':                                       //unlock
      ffSetLock(0);                                 //
      puts("FastFlip unlocked");                    //
      break;                                        //
    case 'P':                                       //set page
      page = atoi(s);                               //
      if (!page)                                    //
      { puts("\aError: Invalid page number\n\n");   //
        DoUsage();                                  //
      }                                             //
      //                                            //
      // make sure requested page is defined        //
      //                                            //
      maxpages = ffGetMaxPage();                    //
      if (page > maxpages)                          //
      { puts("\aError: Invalid page number\n\n");   //
        DoUsage();                                  //
      }                                             //
      ffSetPage(--page);                            //make 0 based
      break;                                        //
    case 'T':                                       //set timer
      i = atoi(s);                                  //
      if (i)                                        //
        ffSetTimer(i);                              //
      break;                                        //
  }
}

//
//------------------------------------------------------------------------
// main
//------------------------------------------------------------------------
//
int  main(int argc, char *argv[])
{
  puts("\nFastFlip Control Program");
  puts("Copyright (c) 1992 Chris Curran");
  puts("---------------------------------------------------------------");

  //
  // is fastflip loaded?
  //
  if (!ffLoaded())
  { puts("\n\aFastFlip is not loaded\n");
    exit(1);
  }

  argc = DoArgs(argv,'-',NULL,_ArgProc);
  if (!argc)
    DoUsage();
  return 0;
}
