procedure CHKCMMD (var Cmmd: cmmdtype; var Parm: parmtype; var Ipos: integer;
    line: text255);
{ Check for the presence of one of the SURFMODL symbolic commands at the
  beginning of the line, and set Ipos to point immediately after the colon.
}
var i: integer;
    p: integer;
    Srch: string[30];           { search string }
    Astrsk: integer;            { pos of asterisk on line }
    Nline: text255;             { copy of Line after removing cmmd }
    Sym: boolean;               { is the command have symbolic param? }

begin

  { Avoid searching if not starting with an alpha: }
  if (line[1] < 'A') or (line[1] > 'Z') then begin
    Cmmd := CMD_NONE;
    exit;
  end;

  { Got a command - see what it is }

  i := 1;
  Cmmd := CMD_INVALID;
  Sym := FALSE;
  while (i <= MAXCMMD) and (Cmmd = CMD_INVALID) do begin
    with cmmd_name[i] do begin
      Srch := Cname + ':';
      p := pos (Srch, line);
      if (p = 1) then begin
        Cmmd := Ctype;
        Ipos := length (Srch) + 1;
        Sym := Sym_param;
      end;
    end; { with }
    i := i + 1;
  end; { while }

  { If command accepts a symbolic parameter, read it: }
  if (Sym) then begin
    { First check for a comment.  Start looking after the command string: }
    Nline := copy (Line, Ipos, 255);
    Astrsk := pos ('*', Nline);
    if (Astrsk = 0) then
      Astrsk := 999;
    i := 1;
    Parm := PRM_NONE;
    while (i <= MAXPARM) and (Parm = PRM_NONE) do begin
      with parm_name[i] do begin
        p := pos (Pname, Nline);
        if (p > 0) and (p < Astrsk) then begin
          { Found a parameter before the comment begins. }
          Parm := Ptype;
          { Position at EOL so no more processing performed in Inreal }
          Ipos := length (Line) + 1;
        end;
      end; { with }
      i := i + 1;
    end; { while }

    if (Parm = PRM_NONE) then
      { No symbolic parameter found }
      Cmmd := CMD_INVALID;
  end; { if Sym }

end; { procedure CHKCMMD }

