#include <stdio.h>
#include "sb.h"

FM_Instrument instrument = {
    0x11, 0x01, 0x8a, 0x40,
    0xf1, 0xf1, 0x11, 0xb3,
    0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00
};

/* Chromatic scale starting from C# */
int notes[12] = {0x16B,0x181,0x198,0x1B0,0x1CA,0x1E5,
                 0x202,0x220,0x241,0x263,0x287,0x2AE};

void main()
{

    if(Sb_Get_Params())
    {
        puts("BLASTER environment variable not set.");
        exit(1);
    }

    Sb_FM_Reset();

    Sb_FM_Set_Voice(0,&instrument);
    Sb_FM_Set_Voice(1,&instrument);
    Sb_FM_Set_Voice(2,&instrument);
    Sb_FM_Set_Voice(3,&instrument);

    Sb_FM_Key_On(0,notes[11],2);
    Sb_FM_Key_On(1,notes[3],3);
    Sb_FM_Key_On(3,notes[6],3);
    Sb_FM_Key_On(3,notes[11],3);

    getch();

    Sb_FM_Key_Off(0);
    Sb_FM_Key_Off(1);
    Sb_FM_Key_Off(2);
    Sb_FM_Key_Off(3);

    Sb_FM_Reset();
}

