/* This program reads a string from the screen at a specified location
   and compares it with the string entered at the command line.  If the
   two strings are identical, the value 0 is returned to DOS; otherwise,
   the value 1 is returned.  The value -1 is returned if the command line
   arguements are not correct.

   This program is entended to be used in batch files.  The returned value
   can be tested by putting an IF ERRORLEVEL statement after the command.

   Syntax:

   READSCRN column row string

   column     The column at which the string begins on the screen.  The value
              should be between 0 and the number of columns minus one.

   row        The number of rows above the command line at which the string
              is located on the screen.  The value should be between 0 and
              the number of rows minus one.

   string     The string that is to be compared.  It must be enclosed in double
              quotes if a space is part of the string.  The length of the
              string is only limited by the length of the DOS command line.

Examples:

   If you want to read the READSCRN command line and assume the DOS prompt is
   C:\>, type the following:

       READSCRN 0 0 "C:/>READSCRN"

   The command will return 0 to the command processor.

   If you want to check the string "This is a test." two rows above the current
   command line and the string begins at the fifth column, type the following:

       READSCRN 4 2 "This is a test."

   The command will return 0 to the command processor.


   Author:     Jimmy Ning
   CompuServe: [76066,1467]

   This program was compiled in TC 2.01 using the tiny memory model and
   converted to a COM file by using EXE2BIN.                                 */

#include <stdlib.h>
#include <string.h>
#include <dos.h>

/* ROM BIOS video interrupt */
#define VIDEO 0x10

/* This procedure gets the location of the cursor on the screen. */
void get_cursor(int *row, int *col);

/* This procedure returns a character from the screen at location
   (col, row). */
char readxy(int col, int row);

/* This procedure moves the cursor to location (col, row). */
/* Does anyone know why the gotoxy() procedure in conio.h does not work
   properly? */
void gotoxy(int col, int row);

void main(int argc, char *argv[])
{
 int curr_row, curr_col;         /* Current location of the cursor */
 int i = 0;                      /* A counter */
 int row, col;                   /* Location of the string */
 int len;                        /* The length of the string */

 if (argc != 4){
    puts("Three arguements are required!");
    exit(-1);
 }

 get_cursor(&curr_col, &curr_row); /* Save the location */
 col = atoi(argv[1]);
 row = atoi(argv[2]);
 len = strlen(argv[3]);

 while ( (argv[3][i] == readxy(col+i, curr_row-row-1))
          && (i < len) )
     i++;

 gotoxy(curr_col, curr_row);            /* Restore the location of the cursor */
 if (i == len)                          /* Are the two strings identical? */
    exit(0);
 else
     exit(1);
}

/* This procedure gets the location of the cursor on the screen. */
void get_cursor(int *col, int *row)
{
 union REGS regs;

 regs.h.ah = 0x03;               /* Get cursor position */
 regs.h.bh = 0;                  /* Display page 0 */
 int86(VIDEO, &regs, &regs);     /* BIOS video call */

 *row = regs.h.dh;
 *col = regs.h.dl;
}

/* This procedure returns a character from the screen at location
   (row, col). */
char readxy(int col, int row)
{
 union REGS regs;

 gotoxy(col, row);               /* Goto location (col, row) */
 regs.h.ah = 0x08;               /* Read character */
 regs.h.bh = 0;                  /* Display page 0 */
 int86(VIDEO, &regs, &regs);     /* BIOS video call */

 return(regs.h.al);
}

/* This procedure moves the cursor to location (col, row). */
void gotoxy(int col, int row)
{
 union REGS regs;

 regs.h.ah = 2;                  /* Set cursor position */
 regs.h.bh = 0;                  /* Display page 0 */
 regs.h.dh = row;
 regs.h.dl = col;
 int86(VIDEO, &regs, &regs);     /* BIOS video call */
}