TITLE  'Get Bit Block EGA - VIDEO SYSTEMS p.352'
NAME   GETBLOCK
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      copy bit block from video buffer to RAM in EGA/VGA     |
;   caller:      FAR call (QuickBASIC convention)                       |
;                GETBLOCK(15,0,0,319,199,vseg,voff)                     |
;    stack:     +06 = offset of storage                                 |
;                08 = segment of storage                                |
;                10 = y1                                                |
;                12 = x1                                                |
;                14 = y0                                                |
;                16 = x0                                                |
;                18 = plane mask                                        |
;  returns:      nothing                                                |
;     NOTE:      plane mask (bit3=plane3,bit2=plane2,bit1=plane1,bit0...|
;     NOTE:      SS overrides used to access some BSS data              |
;------------------------------------------------------------------------

PARMS           =  7            ;number of arguments
ARGmask         EQU [bp+18]     ;plane mask
ARGx0           EQU [bp+16]     ;upper left col (0-based)
ARGy0           EQU [bp+14]     ;upper left row
ARGx1           EQU [bp+12]     ;lower right col
ARGy1           EQU [bp+10]     ;lower right row
ARGaddrSeg      EQU [bp+08]     ;segment of storage
ARGaddrOff      EQU [bp+06]     ;offset of storage
ByteOffsetShift EQU 3           ;number of pixels per byte

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

GetBlock_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME  cs:GetBlock_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  GetBlock
GetBlock        PROC    FAR

                push    bp
                mov     bp,sp
                push    bp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGmask
                mov     ax,[bx]
                and     ax,000Fh
                mov     PMask,ax        ;bits3-0 are plane mask
                jnz     GB1
                jmp     GBxit           ;must have a plane
GB1:            mov     bx,ARGx0
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGx0
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGy0
                mov     ax,[bx]
                mov     y0,ax
                mov     bx,ARGx1
                mov     ax,[bx]
                mov     x1,ax
                mov     bx,ARGy1
                mov     ax,[bx]
                mov     y1,ax
                mov     bx,ARGaddrOff
                mov     dx,[bx]
                mov     ax,dx
                and     dx,000Fh        ;normalize seg:off
                mov     addrOff,dx
                mov     cl,4
                shr     ax,cl
                mov     bx,ARGaddrSeg
                add     ax,[bx]
                mov     addrSeg,ax

                ;compute bit block dimensions

                mov     ax,x1
                sub     ax,x0
                mov     cx,0FF07h       ;ch = unshifted bit mask
                                        ;cl = AND mask for al
                and     cl,al           ;cl = pixels in last byte of row
                xor     cl,7            ;cl = bits to shift
                shl     ch,cl           ;ch = bit mask for last byte of row
                mov     cl,ch
                push    cx

                mov     cl,ByteOffsetShift
                shr     ax,cl
                inc     ax
                push    ax              ;ax = bytes per row

                mov     ax,y1
                sub     ax,y0
                inc     ax
                push    ax              ;ax = pixel rows

                ;establish addressing

GB01:           mov     ax,y0
                mov     bx,x0
                mov     cx,bpl
                call    PixelAddr       ;es:bx -> x0,y0 in video buffer

                xor     cl,7            ;cl = bits to shift left
                push    es
                pop     ds
                ASSUME ds:nothing
                mov     si,bx           ;ds:si -> video buffer
                mov     di,ss:addrOff   ;es:di -> buffer in RAM (normalized)
                mov     es,ss:addrSeg

                ;build 6-byte bit block header

                pop     ax
                mov     ss:PixelRows,ax
                stosw                   ;byte 0-1 = pixel rows
                pop     ax
                mov     ss:PixelRowLen,ax
                stosw                   ;byte 2-3 = bytes per pixel row
                pop     ax
                mov     ch,al           ;ch = bit mask for last byte in row
                mov     ah,byte ptr PMask
                stosw                   ;byte 4 = bit mask for last byte
                                        ;byte 5 = bits3-0=plane mask
                ;set up Graphics Controller

L00:            mov     dx,3CEh         ;dx = Graphics Controller address port
                mov     ax,0005         ;ah = 0 (read mode 0, write mode 0)
                                        ;al = 5 (Mode register number)
                out     dx,ax           ;set up read mode 0
                mov     ax,0304h        ;ah = 3 (first bit plane to read)
                                        ;al = 4 (Read Map Select reg number)

                ;copy from video buffer to RAM

L01:            push    cx
                mov     cl,ah
                mov     bl,1
                shl     bl,cl
                test    bl,byte ptr ss:PMask
                pop     cx
                jnz     L01a            ;this plane okay
                jmp     L03z            ;skip it

L01a:           out     dx,ax           ;select next memory map to read
                push    ax
                push    ss:PixelRows
                push    si              ;offset of x0,y0

L02:            mov     bx,ss:PixelRowLen
                push    si              ;save si at start of pixel row

L03:            lodsw                   ;al = next byte in video buffer
                                        ;ah = (next byte) + 1
                dec     si              ;ds:si -> (next byte) + 1
                rol     ax,cl           ;al = next 4 pixels in row
                stosb                   ;copy to RAM
                dec     bx              ;loop across row
                jnz     L03

                and     es:[di-1],ch    ;mask last byte in row
                pop     si              ;ds:si -> start of row
                add     si,ss:bpl       ;ds:si -> start of next row

                dec     ss:PixelRows
                jnz     L02             ;loop down rows

                pop     si              ;ds:si -> start of bit block
                pop     ss:PixelRows    ;restore pixel rows
                pop     ax              ;ah = last map read
                                        ;al = Read Map Select reg number
L03z:           dec     ah
                js      L04             ;all done?

                mov     bx,cx           ;save cx (done only once per plane)
                mov     bp,di           ;current RAM offset pointer
                and     di,000Fh        ;normalize new seg:off
                mov     cl,4
                shr     bp,cl
                mov     cx,es
                add     cx,bp
                mov     es,cx           ;normalized es:di->next storage byte
                mov     cx,bx           ;put cx back
                jmp     short L01

L04:            mov     ax,-1
GBxit:          pop     di
                pop     si
                pop     ds
                pop     bp
                ASSUME ds:dgroup
                mov     sp,bp
                pop     bp
                RET     PARMS * 2

GetBlock        ENDP

GetBlock_TEXT   ENDS
                END

