TITLE  'Draw Icon (Windows 3.0 Icon)
NAME   DRAWICON
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1991 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      21 Jan 91                                              |
; function:      draw a Windows 3.0 icon                                |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call DRAWICON(0,0,0,vseg,voff)                         |
;    stack:     +06 = offset of storage                                 |
;                08 = segment of storage                                |
;                10 = y                                                 |
;                12 = x                                                 |
;                14 = replace type (if bit 7 then attr 0 is transparant)|
;  returns:      none                                                   |
;     NOTE:      clipped to current 2D window                           |
;------------------------------------------------------------------------

PARMS           = 5             ;number of arguments
ARGaddtype      EQU [bp+14]     ;replace,XOR,OR,AND the bits
ARGx            EQU [bp+12]     ;upper left column
ARGy            EQU [bp+10]     ;upper left  row
ARGaddrSeg      EQU [bp+08]     ;segment of storage
ARGaddrOff      EQU [bp+06]     ;offset of storage
ByteOffsetShift EQU 3           ;number of pixels per byte

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

DrawIcon_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:DrawIcon_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  DrawIcon
DrawIcon        PROC    FAR

                push    bp
                mov     bp,sp
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGx
                mov     ax,[bx]
                add     ax,31           ;drawing right to left
                mov     x0,ax
                mov     bx,ARGy
                mov     ax,[bx]
                mov     y0,ax
                mov     bx,ARGaddrOff
                mov     dx,[bx]
                mov     ax,dx
                and     dx,000Fh        ;normalize seg:off
                mov     addrOff,dx
                mov     cl,4
                shr     ax,cl
                mov     bx,ARGaddrSeg
                add     ax,[bx]
                mov     addrSeg,ax

                mov     es,ax
                mov     di,ax           ;di used to store es
                mov     si,addrOff      ;es:si->icon data
                add     si,511          ;last byte of icon

                ;set graphics controller mode reg

                mov     dx,03CEh        ;graphics controller port address
                mov     ax,0205h        ;al=mode reg number
                out     dx,ax           ;ah=write mode 2/read mode 0

                ;set data rotate\function select reg

                mov     ax,RMWbits
                and     ax,007Fh        ;turn off any transparancy flag (+128)
                mov     ah,al           ;ah = replace type
                mov     al,3            ;al = data rotate\function select reg
                out     dx,ax

                mov     bp,x0           ;column ptr
                mov     cx,32           ;32 rows per icon
L1:             push    cx

                mov     cx,16           ;16 bytes per row
L2:             push    cx              ;save column counter
                mov     al,es:[si]      ;get a byte (2 pixels/byte)
                sub     ah,ah
                push    ax              ;save the other pixel
                and     ax,000Fh        ;low nyb first
                mov     PixelValue,ax

                test    byte ptr RMWbits,80h  ;+128?
                jz      L20             ;no
                or      ax,ax           ;color 0?
                jz      L2a             ;yes

L20:            cmp     bp,X0clip2      ;left of window?
                jb      L2a             ;yes
                cmp     bp,X1clip2      ;right of window?
                ja      L2a             ;yes
                mov     ax,y0           ;//needed for draw a dot below//
                cmp     ax,Y0clip2      ;above window?
                jb      L2a             ;yes
                cmp     ax,Y1clip2      ;below window?
                ja      L2a

                mov     cx,bpl          ;draw a dot
                mov     bx,bp
                call    PixelAddr
                shl     ah,cl           ;ah = bit mask in proper position
                mov     al,8            ;al=bit mask reg number
                out     dx,ax
                mov     al,es:[bx]      ;latch one byte from each pixel plane
                mov     ax,PixelValue   ;al = pixel value
                mov     es:[bx],al      ;update all bit planes

L2a:            dec     bp              ;next pixel column
                pop     ax
                shr     al,1
                shr     al,1
                shr     al,1
                shr     al,1
                mov     PixelValue,ax

                test    byte ptr RMWbits,80h  ;+128?
                jz      L21             ;no
                or      ax,ax           ;color 0?
                jz      L2b             ;yes

L21:            cmp     bp,X0clip2      ;left of window?
                jb      L2b             ;yes
                cmp     bp,X1clip2      ;right of window?
                ja      L2b             ;yes
                mov     ax,y0           ;//needed for draw a dot below//
                cmp     ax,Y0clip2      ;above window?
                jb      L2b             ;yes
                cmp     ax,Y1clip2      ;below window?
                ja      L2b

                mov     cx,bpl          ;draw a dot
                mov     bx,bp
                call    PixelAddr
                shl     ah,cl           ;ah = bit mask in proper position
                mov     al,8            ;al=bit mask reg number
                out     dx,ax
                mov     al,es:[bx]      ;latch one byte from each pixel plane
                mov     ax,PixelValue   ;al = pixel value
                mov     es:[bx],al      ;update all bit planes

L2b:            dec     bp
                mov     es,di           ;restore icon data seg
                dec     si              ;next 2 pixels' data byte
                pop     cx              ;restore column counter
                dec     cx
                jz      L3
                jmp     L2              ;do all 16 byte/32pixels

L3:             add     bp,32           ;restore to right column
                inc     y0              ;next row
                pop     cx
                dec     cx
                jz      L4
                jmp     L1

                ;restore Graphics Controller default states

L4:             mov     dx,03CEh        ;graphics controller port address
                mov     ax,0FF08h       ;default Bit Mask value
                out     dx,ax
                mov     ax,0005         ;default Mode value
                out     dx,ax
                mov     ax,0003         ;default Data Rotate/Function Select
                out     dx,ax

                pop     di
                pop     si
                pop     bp
                RET     PARMS*2

DrawIcon        ENDP

DrawIcon_TEXT   ENDS
                END

