TITLE  'Transform/Translate/Scale in 3D'
NAME   XFORM3D
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Transform/Translate/Scale in 3D                        |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call XFORM3D(vseg,voff)                                |
;    stack:     +06 = offset of 3D data pack                            |
;                08 = segment                                           |
;  returns:      none                                                   |
;------------------------------------------------------------------------

PARMS           = 2
ARGpackseg      EQU [bp+08]
ARGpackoff      EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

XFORM3D_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:XFORM3D_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  XFORM3D
XFORM3D         PROC    FAR

                push    bp
                mov     bp,sp
                push    bp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGpackoff
                mov     si,[bx]
                mov     bx,ARGpackseg
                mov     es,[bx]
                mov     di,offset dgroup:xtype3
                mov     cx,21           ;packet is 21 words
                push    ds
                mov     ax,es
                mov     bx,ds           ;es:di->dgroup:xtype3
                mov     es,bx
                mov     ds,ax           ;ds:si->passed seg:off
                rep     movsw           ;copy xform pack to dgroup
                pop     ds
            
                mov     cx,points3
                or      cx,cx
                jnz     DoNX            ;got some points to work on
                jmp     Trans3Dxit      ;none

DoNX:           mov     si,offXY3
                mov     es,segXYp3
                mov     di,offXYp3      ;es:di -> xyz() prime pts
                mov     bx,10000        ;trig divisor
                mov     bp,100          ;scale divisor

DoN_Loop:       push    cx              ;points

                push    ds
                mov     ds,segXY3       ;ds:si-> xyz() original pts
                lodsw                   ;get x data
                mov     dx,ax           ;to dx
                lodsw                   ;get y data
                mov     cx,ax           ;to cx
                lodsw                   ;get z data to ax
                pop     ds              ;ds->dgroup

                add     ax,transZ3
                mov     z0,ax
                add     cx,transY3
                mov     y0,cx
                add     dx,transX3
                mov     x0,dx           ;x0,y0,z0 are original data translated

; calc N_1 (HEAD)

                mov     ax,degH3
                call    GetTrig
                jnc     DoN_1
                jmp     Trans3Dbad      ;out-of-range

; nx1 = (orgX + (((x0-orgX)*cos(degH) - (z0-orgZ)*sin(degH)) * scaleX))
; ny1 = y0
; nz1 = (orgZ + (((x0-orgX)*sin(degH) + (z0-orgZ)*cos(degH)) * scaleZ))

DoN_1:          mov     ax,x0
                sub     ax,orgX3
                mov     x1,ax           ;x1=(x0-orgX)

                mov     ax,z0
                sub     ax,orgZ3
                mov     z1,ax           ;z1=(z0-orgZ)

                mov     ax,x1
                imul    COSdeg
                idiv    bx              ;ax=(x0-orgX)*cos(degH)

                push    ax

                mov     ax,z1
                imul    SINdeg
                idiv    bx              ;ax=(z0-orgZ)*sin(degH)

                pop     dx
                xchg    ax,dx
                sub     ax,dx   ;ax=(x0-orgX)*cos(degH)-(z0-orgZ)*sin(degH)

                imul     scaleX3
                idiv     bp             ;scale

                add     ax,orgX3        ;restore
                mov     nx1,ax          ;takes care of NX1

                mov     ax,y0
                mov     ny1,ax          ;takes care of NY1
                
                mov     ax,x1
                imul    SINdeg
                idiv    bx              ;ax=(x0-orgX)*sin(degH)
                push    ax

                mov     ax,z1
                imul    COSdeg
                idiv    bx              ;ax=(z0-orgZ)*cos(degH)

                pop     dx
                xchg    ax,dx           ;<-NN
                add     ax,dx   ;ax=(x0-orgX)*sin(degH)+(z0-orgZ)*cos(degH)

                imul     scaleZ3
                idiv     bp             ;scale

                add     ax,orgZ3        ;restore
                mov     nz1,ax          ;takes care of NZ1

;calc N_2
                mov     ax,degP3
                call    GetTrig
                jnc     DoN_2
                jmp     Trans3Dbad      ;out-of-range

; nx2 = nx1
; ny2 = (orgY + (((ny1-orgY)*cos(degP) + (nz1-orgZ)*sin(degP)) * scaleY))
; nz2 = (orgZ + ((-(ny1-orgY)*sin(degP) + (nz1-orgZ)*cos(degP)) * scaleZ))

DoN_2:          mov     ax,nx1
                mov     nx2,ax          ;takes care of NX2

                mov     ax,ny1
                sub     ax,orgY3
                mov     y1,ax           ;y1=(ny1-orgY)

                mov     ax,nz1
                sub     ax,orgZ3
                mov     z1,ax           ;z1=(nz1-orgZ)

                mov     ax,y1
                imul    COSdeg
                idiv    bx              ;ax=(ny1-orgY)*cos(degP)

                push    ax

                mov     ax,z1
                imul    SINdeg
                idiv    bx              ;ax=(nz1-orgZ)*sin(degP)

                pop     dx
                xchg    ax,dx   ;<-NN
                add     ax,dx   ;ax=(ny1-orgY)*cos(degP)+(nz1-orgZ)*sin(degP)

                imul     scaleY3
                idiv     bp             ;scale

                add     ax,orgY3        ;restore
                mov     ny2,ax          ;takes care of NY2

                mov     ax,y1
                not     ax              ;negate (ny1-orgY)
                imul    SINdeg
                idiv    bx              ;ax=(-(ny1-orgY))*sin(degP)
                push    ax

                mov     ax,z1
                imul    COSdeg
                idiv    bx              ;ax=(nz1-orgZ)*cos(degP)

                pop     dx
                xchg    ax,dx           ;<-NN
                add     ax,dx   ;ax=(-(ny1-orgY))*sin(degP)+(nz1-orgZ)*cos(degP)

                imul     scaleZ3
                idiv     bp             ;scale

                add     ax,orgZ3        ;restore
                mov     nz2,ax          ;takes care of NZ2

;calc N_3
                mov     ax,degB3
                call    GetTrig
                jnc     DoN_3
                jmp     Trans3Dbad      ;out-of-range

; nx3 = (orgX + (((nx2-orgX)*cos(degB) + (ny2-orgY)*sin(degB)) * scaleX))
; ny3 = (orgY + ((-(nx2-orgX)*sin(degB) + (ny2-orgY)*cos(degB)) * scaleY))
; nz3 = nz2

DoN_3:          mov     ax,nx2
                sub     ax,orgX3
                mov     x1,ax           ;x1=(nx2-orgX)

                mov     ax,ny2
                sub     ax,orgY3
                mov     y1,ax           ;y1=(ny2-orgY)

                mov     ax,x1
                imul    COSdeg
                idiv    bx              ;ax=(nx2-orgX)*cos(degB)

                push    ax

                mov     ax,y1
                imul    SINdeg
                idiv    bx              ;ax=(ny2-orgY)*sin(degB)

                pop     dx
                xchg    ax,dx   ;<-NN
                add     ax,dx   ;ax=(nx2-orgX)*cos(degB)+(ny2-orgY)*sin(degB)

                imul     scaleX3
                idiv     bp             ;scale

                add     ax,orgX3        ;restore
                mov     nx3,ax          ;takes care of NX3

                mov     ax,x1
                not     ax              ;negate (nx2-orgX)
                imul    SINdeg
                idiv    bx              ;ax=(-(nx2-orgX))*sin(degB)
                push    ax

                mov     ax,y1
                imul    COSdeg
                idiv    bx              ;ax=(ny2-orgY)*cos(degB)

                pop     dx
                xchg    ax,dx           ;<-NN
                add     ax,dx   ;ax=(-(nx2-orgX))*sin(degB)+(ny2-orgY)*cos(degB)

                imul     scaleY3
                idiv     bp             ;scale

                add     ax,orgY3        ;restore
                mov     ny3,ax          ;takes care of NY3

                mov     ax,nz2
                mov     nz3,ax          ;takes care of NZ3

                mov     ax,nx3          ;store the new points ->es:di
                stosw
                mov     ax,ny3
                stosw
                mov     ax,nz3
                stosw

                pop     cx              ;get back points
                dec     cx
                jcxz    Trans3Dxit
                jmp     DoN_Loop

Trans3Dbad:     add     sp,2            ;take cx of the stack
                mov     ax,-1
                jmp     short XFORM3Dxit
Trans3Dxit:     xor     ax,ax
XFORM3Dxit:     pop     di
                pop     si
                pop     ds
                ASSUME ds:dgroup
                pop     bp
                mov     sp,bp
                pop     bp
                RET     PARMS*2
XFORM3D         ENDP


;lookup the COS() & SIN() of degree in ax
;return in COSdeg & SINdeg
;carry set if out-of-range

GetTrig         PROC NEAR

                push    si
                or      ax,ax
                jge     GT0             ;must be positive
                jmp     GTbad

GT0:            cmp     ax,90
                jae     GT1
                ;For cos(  0 -  89) TrigTable (forward order)
                ;For sin(  0 -  89) TrigTableEnd (reverse order)
                mov     si,offset dgroup:TrigTable
                shl     ax,1            ;use ax as ptr into word table
                add     si,ax           ;si->cos(deg) in TrigTable
                mov     si,[si]
                mov     COSdeg,si
                mov     si,offset dgroup:TrigTableEnd
                sub     si,ax           ;si->sin(deg) in TrigTable
                mov     si,[si]
                mov     SINdeg,si
                jmp     short GTxit

GT1:            cmp     ax,180
                jae     GT2
                ;For cos( 90 - 179) TrigTableEnd (reverse order & negative)
                ;For sin( 90 - 179) TrigTable (forward order)
                mov     si,offset dgroup:TrigTableEnd
                sub     ax,90
                shl     ax,1
                sub     si,ax
                mov     si,[si]
                neg     si
                mov     COSdeg,si
                mov     si,offset dgroup:TrigTable
                add     si,ax
                mov     si,[si]
                mov     SINdeg,si
                jmp     short GTxit

GT2:            cmp     ax,270
                jae     GT3
                ;For cos(180 - 269) TrigTable (forward order & negative)
                ;For sin(180 - 269) TrigTableEnd (reverse order & negative)
                mov     si,offset dgroup:TrigTable
                sub     ax,180
                shl     ax,1
                add     si,ax
                mov     si,[si]
                neg     si
                mov     COSdeg,si
                mov     si,offset dgroup:TrigTableEnd
                sub     si,ax
                mov     si,[si]
                neg     si
                mov     SINdeg,si
                jmp     short GTxit

GT3:            cmp     ax,359
                ja      GTbad
                ;For cos(270 - 359) TrigTableEnd (reverse order)
                ;For sin(270 - 359) TrigTable (forward order & negative)
                mov     si,offset dgroup:TrigTableEnd
                sub     ax,270
                shl     ax,1
                sub     si,ax
                mov     si,[si]
                mov     COSdeg,si
                mov     si,offset dgroup:TrigTable
                add     si,ax
                mov     si,[si]
                neg     si
                mov     SINdeg,si
GTxit:          clc
                pop     si
                ret

GTbad:          stc     ;above 359
                pop     si
                ret
GetTrig         ENDP

XFORM3D_TEXT    ENDS
                END

