TITLE  'Put Bit Block EGA - VIDEO SYSTEMS p.355'
NAME   PUTBLOCK
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      copy RAM to video buffer RAM in EGA\VGA                |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call PUTBLOCK(0,0,0,vseg,voff)                         |
;    stack:     +06 = offset of storage                                 |
;                08 = segment of storage                                |
;                10 = y                                                 |
;                12 = x                                                 |
;                14 = replace type                                      |
;  returns:      none                                                   |
;     NOTE:      SS overrides used to access some BSS data              |
;------------------------------------------------------------------------

PARMS           = 5             ;number of arguments
ARGaddtype      EQU [bp+14]     ;replace,XOR,OR,AND the bits
ARGx            EQU [bp+12]     ;upper left column
ARGy            EQU [bp+10]     ;upper left  row
ARGaddrSeg      EQU [bp+08]     ;segment of storage
ARGaddrOff      EQU [bp+06]     ;offset of storage
ByteOffsetShift EQU 3           ;number of pixels per byte

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

PutBlock_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:PutBlock_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  PutBlock
PutBlock        PROC    FAR

                push    bp
                mov     bp,sp
                push    bp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGx
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGy
                mov     ax,[bx]
                mov     y0,ax
                mov     bx,ARGaddrOff
                mov     dx,[bx]
                mov     ax,dx
                and     dx,000Fh        ;normalize seg:off
                mov     addrOff,dx
                mov     cl,4
                shr     ax,cl
                mov     bx,ARGaddrSeg
                add     ax,[bx]
                mov     addrSeg,ax

                ;establish addressing

                mov     ax,y0
                mov     bx,x0
                mov     cx,bpl
                call    PixelAddr       ;es:bx -> x,y in video buffer
                inc     cl
                and     cl,7            ;cl = bits to shift left
                mov     di,bx           ;es:di -> x,y in video buffer

                mov     si,addrOff      ;ds:si -> buffer in RAM
                mov     ds,addrSeg
                ASSUME ds:nothing       ;may be far data

                ;get dimensions of bit block from 6-byte header

                lodsw                   ;ax = pixel rows
                mov     ss:PixelRows,ax
                lodsw                   ;ax = bytes per pixel row
                mov     ss:PixelRowLen,ax
                lodsw                   ;al = bit mask for last byte in row
                mov     ch,al           ;ah = plane mask
                mov     byte ptr PMask,ah

                ;set up Graphics Controller

                mov     dx,3CEh         ;dx = Graphics Controller I/O port
                mov     ah,byte ptr ss:RMWbits ;ah = value for Data Rotate/Funct
                mov     al,3            ;select register
                out     dx,ax           ;update this register

                mov     ax,0805h        ;ah = 8 (read mode 1, write mode 0)
                out     dx,ax           ;set up read mode 0
                mov     ax,0007         ;ah = 0 (don't care for all maps
                                        ;        CPU reads always return 0FFh)
                                        ;al = 7 (Color Don't Care reg number)
                out     dx,ax           ;set up Color Don't Care reg

                mov     ax,0FF08h       ;ah = 0FFh (value for Bit Mask reg)
                out     dx,ax           ;set up Bit Mask reg

                mov     dl,0C4h         ;dx = 3C4h (Sequencer I/O port)
                mov     ax,0802h        ;ah = 00001000b (value for Map Mask reg)
                                        ;al = 2 (Map Mask register number)
                cmp     cx,0FF00h       ;if mask <> 0FFh or bits to shift <> 0
                jne     L15             ; jump if not byte-aligned

                ;routine for byte-aligned bit blocks

                mov     cx,ss:PixelRowLen

L10:            test    ah,byte ptr ss:PMask ;plane okay?
                jz      L13             ;skip it
                out     dx,ax           ;enable one bit plane for writes
                push    ax              ;Map Mask calue
                push    di              ;video buffer offset of x,y
                mov     bx,ss:PixelRows

L11:            push    di
                push    cx

L12:            lodsb                   ;al = next byte of pixels from RAM
                and     es:[di],al      ;update bit plane row
                inc     di
                loop    L12

                pop     cx
                pop     di
                add     di,ss:bpl       ;es:di -> next pixel row in buffer
                dec     bx
                jnz     L11             ;loop down pixel rows

                pop     di              ;es:di -> video buffer offset of x,y
                pop     ax              ;ah = current Map Mask reg value
L13:            shr     ah,1            ;ah = new Map Mask value
                jz      L14             ;done with all bit planes?

                mov     bx,cx           ;save cx (done only once per plane)
                mov     bp,si           ;current RAM offset pointer
                and     si,000Fh        ;normalize new seg:off
                mov     cl,4
                shr     bp,cl
                mov     cx,ds
                add     cx,bp
                mov     ds,cx           ;normalized ds:si->next storage byte
                mov     cx,bx           ;put cx back
                jmp     short L10

L14:            jmp     Lexit

                ;routine for non-aligned bit blocks

L15:            push    ax              ;Map Mask reg values
                mov     bx,0FFh         ;bh = 0 (mask for first byte in row)
                                        ;bl = 0FFh
                mov     al,ch           ;al = mask for last byte in pixel row
                cbw                     ;ah = 0FFh (mask for last-1 byte)

                cmp     ss:PixelRowLen,1
                jne     L16             ;jump if more than one byte per row

                mov     bl,ch
                mov     ah,ch           ;ah = mask for last-1 byte
                xor     al,al           ;al = 0 (mask for last byte)

L16:            shl     ax,cl           ;shift masks into position
                shl     bx,cl
                mov     bl,al           ;save masks along with ...
                mov     al,8            ;Bit Mask register number
                mov     ss:EndMaskL,ax
                mov     ah,bl
                mov     ss:EndMaskR,ax
                mov     ah,bh
                mov     ss:StartMask,ax

                mov     bx,ss:PixelRowLen
                pop     ax              ;Map Mask register values

                ;set pixels row by row in the bit planes

L17:            test    ah,byte ptr ss:PMask ;plane okay?
                jnz     L17a            ;yes
                jmp     L23             ;no

L17a:           out     dx,ax           ;enable one bit plane for writes
                push    ax              ;Map Mask value
                push    di              ;video buffer offset of x,y
                mov     dl,0CEh         ;dx = 3CEh (Graphics Controller port)

                mov     ax,ss:PixelRows
                mov     ss:RowCounter,ax;initialize loop counter

                ;set pixels at start of row in currently enabled bit plane

L18:            push    di              ;offset of start of pixel row
                push    si              ;offset of row in bit block
                push    bx              ;bytes per pixel row

                mov     ax,ss:StartMask
                out     dx,ax           ;set Bit Mask reg for first byte of row
                lodsw                   ;ah = 2nd byte of pixels
                                        ;al = 1st byte of pixels
                                        ;ds:si -> 2nd byte of pixels
                dec     si
                test    cl,cl
                jnz     L19             ;jump if not left-aligned

                dec     bx              ;bx = bytes per row -1
                jnz     L20             ;jump if at least 2 bytes per row
                jmp     short L22       ;     if only 1 byte per row

L19:            rol     ax,cl           ;ah = left part of 1st byte,
                                        ;     right part of 2nd byte
                                        ;al = right part of first byte,
                                        ;     left part of 2nd byte
                and     es:[di],ah      ;set pixels for left part of first byte
                inc     di
                dec     bx              ;bx = bytes per row -2

L20:            push    ax              ;pixels
                mov     ax,0FF08h
                out     dx,ax           ;set Bit Mask reg for succeeding bytes
                pop     ax

                dec     bx
                jng     L22             ;jump if only 1 or 2 bytes in pixel row

                ;set pixels in middle of row

L21:            and     es:[di],al      ;set pixels in right part of current
                inc     di              ; byte and left part of next byte

                lodsw                   ;ah = next+1 byte of pixels
                dec     si              ;al = next byte of pixels
                rol     ax,cl           ;ah = left part of next byte, right
                                        ; part of next+1 byte
                                        ;al = right part of next byte, left
                                        ; part of next+1 byte
                dec     bx
                jnz     L21             ;loop across pixel row

                ;set pixels at end of row

L22:            mov     bx,ax           ;bh = right part of last byte, left
                                        ; part of last-1 byte
                                        ;bl = left part of last byte, right
                                        ; part of last-1 byte
                mov     ax,ss:EndMaskL  ;ah = mask for last-1 byte
                                        ;al = Bit Mask reg number
                out     dx,ax           ;set Bit Mask register
                and     es:[di],bl      ;set pixels for last-1 byte

                mov     ax,ss:EndMaskR  ;mask for last byte in pixel row
                out     dx,ax           ;last byte in pixel row
                and     es:[di+1],bh    ;set pixels for last byte

                pop     bx              ;bx = bytes per pixel row
                pop     si
                add     si,bx           ;ds:si -> next row in bit block
                pop     di
                add     di,ss:bpl       ;es:di -> next pixel row in buffer
                dec     ss:RowCounter
                jnz     L18             ;loop down pixel rows

                pop     di              ;es:di -> video buffer offset of x,y
                pop     ax              ;ax = current Map Mask value
                mov     dl,0C4h         ;dx = 03C4h
L23:            shr     ah,1            ;ah = next Map Mask value
                jz      Lexit           ;done with all bit planes?

                push    cx              ;save cx (done once/plane,bx not avail)
                mov     bp,si           ;current RAM offset pointer
                and     si,000Fh        ;normalize new seg:off
                mov     cl,4
                shr     bp,cl
                mov     cx,ds
                add     cx,bp
                mov     ds,cx           ;normalized ds:si->next storage byte
                pop     cx              ;get cx back
                jmp     L17

                ;restore Graphics Controller and Sequencer to default states

Lexit:          mov     ax,0F02h        ;default Map Mask value
                out     dx,ax

                mov     dl,0CEh         ;dx = 3CEh
                mov     ax,0003         ;default Data Rotate/Function Select
                out     dx,ax

                mov     ax,0005         ;default Mode value
                out     dx,ax

                mov     ax,0F07h        ;default Color Compare value
                out     dx,ax

                mov     ax,0FF08h       ;default Bit Mask value
                out     dx,ax

                pop     di
                pop     si
                pop     ds
                pop     bp
                ASSUME ds:dgroup
                mov     sp,bp
                pop     bp
                RET     PARMS*2

PutBlock        ENDP
PutBlock_TEXT   ENDS
                END

