#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__putc = "$Header: c:/curses/private/RCS/_putc.c%v 2.0 1992/11/15 03:24:30 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_putc()	- Output a character in the current attribute.

  PDCurses Description:
 	This is a private PDCurses routine.

 	Outputs character 'chr' to screen in tty fashion. If a colour
 	mode is active, the character is written with colour 'colour'.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_putc( chtype character, chtype color );

**man-end**********************************************************************/

int	PDC_putc( chtype character, chtype color )
{
#ifdef	FLEXOS
	int	x = color;
	retcode = s_write(0x00, 0x01L, (_far char *) &character, 1L, 0);
	return( (retcode < 0L) ? ERR : OK );
#endif
#ifdef	DOS
	regs.h.ah = 0x0a;	/* Avoid screen wrap.  Don't advance cursor. */
	regs.h.al = (unsigned char) (character & A_CHARTEXT);
	regs.h.bh = _cursvar.video_page;
	regs.h.bl = (unsigned char) ((color & A_ATTRIBUTES) >> 8);
	regs.x.cx = 0;
	int86(0x10, &regs, &regs);
	return( OK );
#endif
#ifdef	OS2
	int curRow = PDC_get_cur_row ();
	int curCol = PDC_get_cur_col ();

	VioWrtTTY ((PCH)&character, 1, 0);
	VioWrtNAttr ((PBYTE)&color, 1, (USHORT)curRow, (USHORT)curCol, 0);
	PDC_gotoxy (curRow, curCol);
	return( OK );
#endif
}
