#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	scroll

#ifndef	NDEBUG
char *rcsid_scroll = "$Header: c:/curses/portable/RCS/scroll.c%v 2.0 1992/11/15 03:28:49 MH Rel $";
#endif





/*man-start*********************************************************************

  scroll()	- scroll window

  X/Open Description:
 	The window is scrolled up one line.  THis involves moving the
 	lines in the window data strcture.

  PDCurses Description:
 	No additional functionality at this time.  Thought it might be
 	be nice to provide reverse scrolling, or scrolling 'n' lines
 	in a positive (down) or negative (up) direction in a future
 	release for the PC platform.

  X/Open Return Value:
 	The scroll() function returns OK on succes and ERR on error.

  PDCurses Errors:
 	It is an error to pass a NULL* window.

  Portability:
 	PDCurses	int scroll( WINDOW* win );
 	X/Open Dec '88	int scroll( WINDOW* win );
 	SysV Curses	int scroll( WINDOW* win );
 	BSD Curses	int scroll( WINDOW* win );

**man-end**********************************************************************/

int	scroll(WINDOW *win)
{
	int	i;
	chtype*	ptr;
	chtype*	temp;
static	chtype	blank;

	if (win == (WINDOW *)NULL)
		return( ERR );

	blank = win->_blank | win->_attrs;

	/*
	 * Check if window scrolls	and cursor in region.
	 */
	if ((!win->_scroll) ||
	    (win->_cury < win->_tmarg) ||
	    (win->_cury > win->_bmarg))
	{
		return( ERR );
	}

	temp = win->_y[win->_tmarg];
	for (i = win->_tmarg; (i < win->_bmarg); i++)
	{
		win->_y[i] = win->_y[i + 1];	/* re-arrange line
							 * pointers */
		win->_firstch[i] = 0;
		win->_lastch[i] = win->_maxx - 1;
	}

	for (ptr = temp; (ptr - temp < win->_maxx); ptr++)
		*ptr = blank;				/* make a blank line */

	win->_y[win->_bmarg] = temp;
	if (win->_cury > win->_tmarg)			/* if not on top line */
		win->_cury--;				/* cursor scrolls too */

	win->_firstch[win->_bmarg] = 0;
	win->_lastch[win->_bmarg] = win->_maxx - 1;
	return( OK );
}
