#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__sysgetc = "$Header: c:/curses/private/RCS/_sysgetc.c%v 2.0 1992/11/15 03:24:39 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_sysgetch()	- Return a character using default system routines.

  PDCurses Description:
 	This is a private PDCurses function.

 	Gets a character without normal ^S, ^Q, ^P and ^C interpretation
 	and returns it.  If keypad mode is active for the designated
 	window, function key translation will be performed. Otherwise,
 	function keys are ignored. If nodelay mode is active in the
 	window, then sysgetch() returns -1 if no character is
 	available.

  PDCurses Return Value:
 	This function returns OK upon success otherwise ERR is returned.

  PDCurses Errors:
 	No errors are defined for this routine.

  Portability:
 	PDCurses	int	PDC_sysgetch( void );

**man-end**********************************************************************/

int	PDC_sysgetch(void)
{
extern	WINDOW*	_getch_win_;
/* extern	WINDOW*	w;*/   /* w defined in wgetch() as static - _getch_win_ */
                        /* is the same window - all references to w changed*/
                        /* to _getch_win_ - marked with @@ */

	signed	c;

	if (_getch_win_ == (WINDOW *)NULL)  /* @@ */
		return (-1);

	if (_getch_win_->_nodelay && !typeahead(stdin))
		return (-1);

	while (1)
	{
		c = PDC_get_bios_key();
#if	defined (DOS) || defined (OS2)
		/*
		 * Return the key if it is not a special key.
		 */
		if (c & A_CHARTEXT)
			return (c & A_CHARTEXT);
#endif
		if ((c = PDC_validchar(c)) >= 0)
		{
			return (c);		/* get & check next char */
		}
	}
}
