#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__chins = "$Header: c:/curses/private/RCS/_chins.c%v 2.0 1992/11/15 03:24:24 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_chins()	- Low-level insert character in window

  PDCurses Description:
 	This is a private PDCurses routine.

 	This routine provides the basic functionality for the X/Open
 	[mv][w]insch() routines.  The xlat flag indicates that normal
 	character translation is performed or not.  If not, then the
 	character is output as is.

 	The 'xlat' flag is TRUE for the normal curses routines.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int PDC_chins( WINDOW* win, chtype c, bool xlat );

**man-end**********************************************************************/

int	PDC_chins(WINDOW *win, chtype c, bool xlat)
{
	int	retval = ERR;
	int	x;
	int	y;
	int	maxx;
	int	offset;
	chtype* temp1;
	register chtype*	dstp;
	register chtype*	srcp;
	char	ch	= (c & A_CHARTEXT);

	if (win == (WINDOW *)NULL)
		return( retval );

	x	= win->_curx;
	y	= win->_cury;
	maxx	= win->_maxx;
	offset	= 1;
	temp1	= &win->_y[y][x];

/*
	if ((ch < ' ') &&
	    ((ch == '\n') ||
	     (ch == '\r') ||
	     (ch == '\t') ||
	     (ch == '\b')))
	{
		retval = PDC_chadd(win, c, xlat,FALSE);
		return( retval );
	}
*/
	if ((ch < ' ') && xlat)
	{
		offset++;
	}

#ifdef	DOS
#  if	SMALL || MEDIUM
	srcp = temp1;
	dstp = temp1+offset;
	movedata(FP_SEG(srcp), FP_OFF(srcp),
		 FP_SEG(dstp), FP_OFF(dstp),
		 (maxx - x -offset) * sizeof(chtype));
#  else
	/* Changed from memcpy to memmove. Should work with
	 * TC and MSC.
	 *	-- MH	920605
	 */
/*	memmove( temp1 + sizeof(chtype), temp1, (maxx - x -1) * sizeof(chtype) );*/
	memmove( temp1+offset, temp1, (maxx - x -offset) * sizeof(chtype) );
#  endif
#endif
#ifdef OS2
	memmove( temp1+offset, temp1, (maxx - x -offset) * sizeof(chtype) );
#endif

	win->_lastch[y] = maxx-1;

	if ((win->_firstch[y] == _NO_CHANGE) ||
	    (win->_firstch[y] > x))
	{
		win->_firstch[y] = x;
	}
	/*
	 * PDC_chadd() fixes CTRL-chars too
	 */
	retval = (PDC_chadd(win, c, xlat,FALSE));
	return( retval );
}
