#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wdelch

#ifndef	NDEBUG
char *rcsid_wdelch = "$Header: c:/curses/portable/RCS/wdelch.c%v 2.0 1992/11/15 03:29:23 MH Rel $";
#endif




/*man-start*********************************************************************

  wdelch()	- remove character from window

  X/Open Description:
 	The character under the cursor in the window is deleted.  All
 	characters to the right on the same line are moved to the left
 	one position and the last character on the line is filled with
 	a blank.  The cursor position does not change (after moving to
 	y, x if coordinates are specified).

 	NOTE: delch(), mvdelch(), and mvwdelch() are macros.

  PDCurses Description:
 	Nothing additional.

  X/Open Return Value:
 	The wdelch() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int wdelch( WINDOW* win );
 	X/Open Dec '88	int wdelch( WINDOW* win );
 	BSD Curses	int wdelch( WINDOW* win );
 	SYS V Curses	int wdelch( WINDOW* win );

**man-end**********************************************************************/

int	wdelch(WINDOW *win)
{
	int		y;
	int		x;
	int		maxx;
	chtype*		temp1;
register chtype*	dstp;
register chtype*	srcp;

	if (win == (WINDOW *)NULL)
		return (ERR);

	y	= win->_cury;
	x	= win->_curx;
	maxx	= win->_maxx - 1;
	temp1	= &win->_y[y][x];

#if 	defined(DOS) || defined(OS2)
#  if	SMALL || MEDIUM
/*	srcp = temp1 + sizeof(chtype); */
	srcp = temp1 + 1;
	dstp = temp1;
	movedata(FP_SEG(srcp), FP_OFF(srcp),
		 FP_SEG(dstp), FP_OFF(dstp),
		 (maxx - x) * sizeof(chtype));
#  else
	/* Changed from memcpy to memmove. Should work with
	 * TC and MSC.
	 *	-- MH	920605
	 */
/*	memmove( temp1, temp1 + sizeof(chtype), (maxx - x) * sizeof(chtype) );*/
	memmove( temp1, temp1 + 1, (maxx - x) * sizeof(chtype) );
#  endif
#endif

	win->_y[y][maxx] = win->_blank | win->_attrs;
	win->_lastch[y] = maxx;

	if ((win->_firstch[y] == _NO_CHANGE) ||
	    (win->_firstch[y] > x))
	{
		win->_firstch[y] = x;
	}
	return (OK);
}
