#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	savetty

#ifndef NDEBUG
char *rcsid_savetty = "$Header: c:/curses/portable/RCS/savetty.c%v 2.0 1992/11/15 03:29:13 MH Rel $";
#endif




/*man-start*********************************************************************

  savetty()	- save/restore terminal modes

  X/Open Description:
 	These routines save and restore the state of the terminal modes.
 	The savetty() function saves the current state in a buffer and
 	resetty() restores the state to what it was at the last call to
 	savetty().

  PDCurses Description:
 	FYI: It is very unclear whether this is a duplication of the
 	reset_prog_mode() and reset_shell_mode() functions or whether
 	this is a backing store type of operation.  At this time, they
 	are implemented similar to the reset_*_mode() routines.

  X/Open Return Value:
 	The savetty() function returns OK upon success otherwise ERR is
 	returned.

  Portability:
 	PDCurses	int savetty( void );
 	X/Open Dec '88	int savetty( void );
 	SysV Curses	int savetty( void );
 	BSD Curses	int savetty( void );

**man-end**********************************************************************/

int	savetty(void)
{
	c_save_tty.been_set = TRUE;
#if 	defined(DOS) || defined(OS2)
#  if	SMALL || MEDIUM
	movedata( FP_SEG(&_cursvar),		FP_OFF(&_cursvar),
		  FP_SEG(&c_save_tty.saved),	FP_OFF(&c_save_tty.saved),
		  sizeof(SCREEN) );
#  else
	memcpy(&c_save_tty.saved, &_cursvar, sizeof(SCREEN));
#  endif
#endif
	return( OK );
}
