#define	CURSES_LIBRARY	1
#include <curses.h>
#undef pair_content

#ifndef	NDEBUG
char *rcsid_paircont = "$Header: c:/curses/portable/RCS/paircont.c%v 2.0 1992/11/15 03:29:07 MH Rel $";
#endif




/*man-start*********************************************************************

  pair_content()	- Obtain color-pair information.

  PDCurses Description:

 	This routine is used to determine what the colors of a given color-pair
 	consist of.

 	The routine uses three arguments: the colorpair number which
 	must be a value between 1 and COLOR_PAIRS-1 and the adresses of
 	two shorts for storing the obtained color components of foreground
 	and background. The function will store the current values at these
 	addresses passed. The values will be between 0 and COLORS-1.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a colorpair outside of the
 	range specified above.

  Portability:
 	PDCurses	int pair_content( int colorpair, short *foreground, short *background);
 	SYS V Curses	int pair_content( int colorpair, short *foreground, short *background);

**man-end**********************************************************************/


int pair_content(int colorpair,short *foreground,short *background)
{
 extern int COLOR_PAIRS;
 extern unsigned char atrtab[MAX_ATRTAB];

 if (colorpair >= COLOR_PAIRS || colorpair < 1)
    return(ERR);

 *foreground = (short)(atrtab[colorpair] & 0x0F);
 *background = (short)((atrtab[colorpair] & 0xF0)>>4);
 return(OK);
}
