#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__16bitmo = "$Header: c:/curses/flexos/RCS/_16bitmod.c%v 2.0 1992/11/15 02:42:04 mh Rel $";
#endif




#ifdef	FLEXOS
/*man-start*********************************************************************

  _flexos_16bitmode()	- Puts console 16 bit mode.

  PDCurses Description:
 	This routine sets 16 bit mode (8 bit character +
 	8 bit attribute) for Flexos.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	Under FLEXOS, an ERR will be returned if the s_get() call
 	fails, or if the s_set() call fails.  You are referred to
 	the Flexos Programmer's Reference Guide for details on the
 	actual error.

  Portability:
 	PDCurses	int _flexos_16bitmode( void );

**man-end**********************************************************************/

int	_flexos_16bitmode(void)
{
extern	VIRCON	vir;		/* Allocate a Virtual Console Structure */

	retcode = s_get(T_VIRCON, 0L, (char *) &vir, (long) sizeof(vir));
	if (retcode < 0L)
		return( ERR );

	vir.vc_kbmode = vir.vc_kbmode | (VCKM_NABORT | VCKM_NSTOP |
					 VCKM_NXLAT  | VCKM_NESC  |
					 VCKM_16BIT  | VCKM_NECHO |
					 VCKM_NEOF);

	vir.vc_smode = vir.vc_smode | VCSM_16BIT;

	retcode = s_set(T_VIRCON, 0L, (char *) &vir, (long) sizeof(vir));
	return( (retcode < 0L) ? ERR : OK );
}
#endif
