#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__scrclos = "$Header: c:/curses/private/RCS/_scrclos.c%v 2.0 1992/11/15 03:24:33 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_scr_close()	- Internal low-level binding to close the physical screen

  PDCurses Description:
 	This function provides a low-level binding for the Flexos
 	platform which must close the screen before writing to it.
 	This is a nop for the DOS platform.

 	This function is provided in order to reset the FlexOS 16 bit
 	character set for input rather than the limited input
 	character set associated with the VT52.

  PDCurses Return Value:
 	This function returns OK on success, otherwise an ERR is returned.

  PDCurses Errors:
 	The DOS platform will never fail.  The Flexos platform may fail
 	depending on the ability to close the current virtual console in
 	8 (as opposed to 16) bit mode.

  Portability:
 	PDCurses	int	PDC_scr_close( void );

**man-end**********************************************************************/

int	PDC_scr_close(void)
{
#ifdef	FLEXOS
	_flexos_8bitmode();
	vir.vc_kbmode = kbmode;
	vir.vc_smode = smode;
	vir.vc_mode = cmode;
	retcode = s_set(T_VIRCON, 1L, (char *) &vir, (long) sizeof(vir));
	if  (retcode < 0L)
		return( ERR );
	return( OK );
#endif
#if	defined (DOS) || defined (OS2)
	return( OK );
#endif
}
