#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__sanity = "$Header: c:/curses/private/RCS/_sanity.c%v 2.0 1992/11/15 03:24:32 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_sanity_check() - A video adapter identification sanity check

  PDCurses Description:
 	This is a private PDCurses routine.

 	This routine will force sane values for various control flags.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_sanity_check( int adapter );

**man-end**********************************************************************/

int	PDC_sanity_check(int adapter)
{
	int	fontsize = PDC_get_font();
	int	rows	 = PDC_get_rows();

	switch (adapter)
	{
	case _EGACOLOR:
	case _EGAMONO:
		switch (rows)
		{
		case 25:	break;
		case 43:	break;
		default:
			_cursvar.bogus_adapter = TRUE;
			break;
		}

		switch (fontsize)
		{
		case _FONT8:	break;
		case _FONT14:	break;
		default:
			_cursvar.bogus_adapter = TRUE;
			break;
		}
		break;

	case _VGACOLOR:
	case _VGAMONO:

/*                                                                  */
/* lets be reasonably flexible with VGAs - they could be Super VGAs */
/* capable of displaying any number of lines. MH 10-Jun-92          */
/* This also applies to font size.            MH 16-Jun-92          */
/*
		switch (rows)
		{
		case 25:	break;
		case 43:	break;
		case 50:	break;
		default:
			_cursvar.bogus_adapter = TRUE;
			break;
		}

		switch (fontsize)
		{
		case _FONT8:	break;
		case _FONT14:	break;
		case _FONT16:	break;
		default:
			_cursvar.bogus_adapter = TRUE;
			break;
		}
*/
		break;

	case _CGA:
	case _MDA:
	case _MCGACOLOR:
	case _MCGAMONO:
		switch (rows)
		{
		case 25:	break;
		default:
			_cursvar.bogus_adapter = TRUE;
			break;
		}
		break;

	default:
		_cursvar.bogus_adapter = TRUE;
		break;
	}
	if (_cursvar.bogus_adapter)
	{
		_cursvar.sizeable	= FALSE;
		_cursvar.direct_video	= FALSE;
	}
	return (adapter);
}
