#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wnoutrefresh

#ifndef	NDEBUG
char *rcsid_wnoutref = "$Header: c:/curses/portable/RCS/wnoutref.c%v 2.0 1992/11/15 03:29:36 MH Rel $";
#endif




/*man-start*********************************************************************

  wnoutrefresh()	- do effiecient refresh

  X/Open Description: (part of the wnoutrefresh() description.)
 	These two routines allow multiple updates with more efficiency
 	than wrefresh() alone.  In addition to all of the window
 	structures representing the terminal screen: a physical screen,
 	describing what is actually on the screen and a virtual screen,
 	describing what the programmer wants to have on  the screen.

 	The wrefresh() function works by first calling wnoutrefresh(),
 	which copies the named window to the virtual screen.  It then
 	calls doupdate(), which compares the virtual screen to the
 	physical screen and does the actual update.  If the programmer
 	wishes to output several windows at once, a series of cals to
 	wrefresh() will result in alternating calls to wnoutrefresh()
 	and doupdate(), causing several bursts of output to the
 	screen.  By first calling wnoutrefresh() for each window, it
 	is then possible to call doupdate() once.  This results in
 	only one burst of output, with probably fewer total characters
 	transmitted and certainly less CPU time used.

  PDCurses Description:
 	In addition to the above, if REGISTERWINDOWS is TRUE when the
 	library was compiled, any windows registered (true by default
 	with PDCurses and _cursvar.refreshall is TRUE, then all
 	registered windows will be called via wnoutrefresh() before
 	the actual screen update begins.

  X/Open Return Value:
 	The doupdate() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int wnoutrefresh( WINDOW* w );
 	X/Open Dec '88	int wnoutrefresh( WINDOW* w );
 	BSD Curses	int wnoutrefresh( WINDOW* w );
 	SYS V Curses	int wnoutrefresh( WINDOW* w );

**man-end**********************************************************************/

int	wnoutrefresh(register WINDOW *win)
{
register chtype*	dstp;
register chtype*	srcp;
register int		first;	/* first changed char on line */
register int		last;	/* last changed char on line  */
	int		begy;	/* window's place on screen   */
	int		begx;
	WINDOW*		s;
	int		i;
	int		j;
	int		y;
	int		x;
	int		len;
	chtype		attrs;

	if (win == (WINDOW *)NULL)
		return( ERR );

	y = win->_cury;
	x = win->_curx;
	attrs = win->_attrs;
	if (win->_title != NULL)
		len = strlen(win->_title);
	/*
	 * There may be a better place to implement window titles, but this
	 * seems to be the best place. -- Frotz
	 */
	if ((len > 0) && (win->_title != NULL) && !(win->_flags & _SUBWIN))
	{
		wattrset(win, win->_title_attr);
		mvwprintw(win, 0, (win->_title_ofs), "%s", (long) win->_title);
		wmove(win, y, x);	/* restore cursor postion */
		wattrset(win, attrs);	/* restore attributes	  */
	}

	if (win->_flags & _PAD)
		return( ERR );

	s = tmpwin;
	begy = win->_begy;
	begx = win->_begx;

	for (i = 0, j = begy; i < win->_maxy; i++, j++)
	{
		if (win->_firstch[i] != _NO_CHANGE)
		{
			first = win->_firstch[i];
			last = win->_lastch[i];

#if 	defined(DOS) || defined(OS2)
#  if	SMALL || MEDIUM
			srcp = &(win->_y[i][first]);
			dstp = &(s->_y[j][begx + first]);
			movedata( FP_SEG(srcp), FP_OFF(srcp),
				  FP_SEG(dstp), FP_OFF(dstp),
				  (last - first + 1) * sizeof(chtype));
#  else
			memcpy(&(s->_y[j][begx + first]),
			       &(win->_y[i][first]),
			       (last - first + 1) * sizeof(chtype));
#  endif
#endif
			first += begx;	/* s's min/max change positions */
			last += begx;

			if (s->_firstch[j] != _NO_CHANGE)
				s->_firstch[j] = min(s->_firstch[j], first);
			else
				s->_firstch[j] = first;

			s->_lastch[j] = max(s->_lastch[j], last);

			win->_firstch[i] = _NO_CHANGE;	/* updated now */
		}
		win->_lastch[i] = _NO_CHANGE;	/* updated now */
	}

	if (win->_clear)
	{
		win->_clear = FALSE;
		s->_clear = TRUE;
	}

	if (!win->_leave)
	{
		s->_cury = win->_cury + begy;
		s->_curx = win->_curx + begx;
	}
	return( OK );
}
