#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	intrflush

#ifndef	NDEBUG
char *rcsid_intrflus = "$Header: c:/curses/portable/RCS/intrflus.c%v 2.0 1992/11/15 03:28:57 MH Rel $";
#endif




/*man-start*********************************************************************

  intrflush()	- enable flush on interrupt

  X/Open Description:
 	If this option is enabled (bf is TRUE), and an interrupt is
 	pressed on the keyboard (INTR, BREAK, or QUIT) all output in
 	the terminal driver queue will be flushed, giving the effect
 	of faster response to the interrupt but causing curses to have
 	the wrong idea of what is on the screen.  Disabling the option
 	prevents the flush.  The default for the option is inherited
 	from the terminal driver settings.  The window argument is
 	ignored.

  PDCurses Description:
 	No additional functionality.

  X/Open Return Value:
 	The intrflush() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int intrflush( WINDOW* win, bool bf );
 	X/Open Dec '88	int intrflush( WINDOW* win, bool bf );
 	BSD Curses	
 	SYS V Curses	

**man-end**********************************************************************/

int	intrflush( WINDOW *win, bool bf )
{
#ifdef	TC
#  pragma argsused
#endif
	int	y;
	int	maxy;

	if (win == (WINDOW *)NULL)
		return( ERR );

	maxy = win->_maxy - 1;

	for (y = 0; y <= maxy; y++)
	{
		win->_firstch[y] = _NO_CHANGE;
	}
	return( OK );
}
