#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__getattr = "$Header: c:/curses/private/RCS/_getattr.c%v 2.0 1992/11/15 03:24:23 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_get_attribute()	- Get attribute at current cursor

  PDCurses Description:
 	This is a private PDCurses function

 	Return the current attr at current cursor position on the screen.

  PDCurses Return Value:
 	This routine will return OK upon success and otherwise ERR will be
 	returned.

  PDCurses Errors:
 	There are no defined errors for this routine.

  Portability:
 	PDCurses	int	PDC_get_attribute( void );

**man-end**********************************************************************/

int	PDC_get_attribute(void)
{
#ifdef	FLEXOS
	/* Get and return current attribute.  Force error until fixed. */
	return ((COLOR_CYAN) >> ((sizeof(ch type) / 2) * 8));
#endif
#ifdef	DOS
	regs.x.ax = 0x0800;
	regs.h.bh = _cursvar.video_page;
	int86(0x10, &regs, &regs);
	return ((int) regs.h.ah);
#endif
#ifdef	OS2
	char Cell[4];
	USHORT cellLen = 2;
	USHORT curRow = PDC_get_cur_row();
	USHORT curCol = PDC_get_cur_col();
	VioReadCellStr((PCH)&Cell, (PUSHORT)&cellLen, (USHORT)curRow, (USHORT)curCol, 0);
	return ((int) Cell[1]);
#endif
}
