#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	overlay

#ifndef	NDEBUG
char *rcsid_overlay = "$Header: c:/curses/portable/RCS/overlay.c%v 2.0 1992/11/15 03:29:35 MH Rel $";
#endif




/*man-start*********************************************************************

  overlay()	- Overlay windows

  X/Open Description:	overlay() and overwrite()
 	These functions overlay src_w on top of dst_w; that is,
 	all text in src_w is copied into dst_w. The windows
 	src_w and dst_w are not required to be the same size. The
 	copy starts at (0, 0) on each window. The difference between
 	the two functions is that overlay() is non-destructive
 	(blanks are not copied) while overwrite() is destructive
 	(blanks are copied).

  PDCurses Description:
 	No additional PDCurses functionality.

  X/Open Return Value:
 	The overlay() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to pass a NULL window pointer.

  Portability:
 	PDCurses	int	overlay( WINDOW* src_w, WINDOW* dst_w );
 	X/Open Dec '88	int	overlay( WINDOW* src_w, WINDOW* dst_w );
 	BSD Curses	int	overlay( WINDOW* src_w, WINDOW* dst_w );
 	SYS V Curses	int	overlay( WINDOW* src_w, WINDOW* dst_w );

**man-end**********************************************************************/

int	overlay(WINDOW *src_w, WINDOW *dst_w)
{
	int*	minchng;
	int*	maxchng;
	chtype*	w1ptr;
	chtype*	w2ptr;
	chtype	attrs;
	int	col;
	int	line;
	int	last_line;
	int	last_col;

	if (src_w == (WINDOW *)NULL)	return( ERR );
	if (dst_w == (WINDOW *)NULL)	return( ERR );

	minchng	  = dst_w->_firstch;
	maxchng   = dst_w->_lastch;
	last_col  = min(src_w->_maxx, dst_w->_maxx) - 1;
	last_line = min(src_w->_maxy, dst_w->_maxy) - 1;
	attrs	  = dst_w->_attrs;

	for (line = 0; line <= last_line; line++)
	{
		register int fc;
		register int lc;

		w1ptr = src_w->_y[line];
		w2ptr = dst_w->_y[line];
		fc    = _NO_CHANGE;

		for (col = 0; col <= last_col; col++)
		{
			if ((*w1ptr & A_CHARTEXT) != src_w->_blank)
			{
				*w2ptr = (*w1ptr & A_CHARTEXT) | attrs;
				if (fc == _NO_CHANGE)
				{
					fc = col;
				}
				lc = col;
			}
			w1ptr++;
			w2ptr++;
		}

		if (*minchng == _NO_CHANGE)
		{
			*minchng = fc;
			*maxchng = lc;
		}
		else	if (fc != _NO_CHANGE)
		{
			if (fc < *minchng)	*minchng = fc;
			if (lc > *maxchng)	*maxchng = lc;
		}
		minchng++;
		maxchng++;
	}
	return( OK );
}
