#define CURSES_LIBRARY	1
#include <curses.h>
#undef  noraw

#ifndef NDEBUG
char *rcsid_noraw = "$Header: c:/curses/portable/RCS/noraw.c%v 2.0 1992/11/15 03:29:06 MH Rel $";
#endif




/*man-start*********************************************************************

  noraw()	- disable raw mode

  X/Open Description:
        The terminal in placed into or out of raw mode.  Raw mode is
        similar to cbreak mode, in that characters typed are immediately
        passed through to the user program.  The differences are that in
        raw mode, the INTR, QUIT, SUSP, and STOP characters are passed
        through without being interpreted, and without generating a
        signal.  The behaviour of the BREAK key depends on other
        parameters of the terminal drive that are not set by curses.

  PDCurses Description:
        Raw mode in the traditional sense refers to input handling.
        Contrast noraw_output() which disables 8bit characters.

        FYI:	PDCurses does NOT provide signal(3) support,
 		this must be done by the application.

  X/Open Return Value:
        The noraw() function returns OK on success and ERR on error.

  X/Open Errors:
        No errors are defined for this function.

  Portability:
        PDCurses        int noraw( void );
        X/Open Dec '88  int noraw( void );
        BSD Curses      int noraw( void );
        SYS V Curses    int noraw( void );

**man-end**********************************************************************/

int     noraw(void)
{
#ifdef OS2
	KBDINFO KbdInfo;

	KbdGetStatus(&KbdInfo,0);
	KbdInfo.fsMask |= KEYBOARD_ASCII_MODE;
	KbdInfo.fsMask &= ~KEYBOARD_BINARY_MODE;
	KbdSetStatus(&KbdInfo,0);
#endif
	_cursvar.raw_inp = FALSE;
	PDC_set_ctrl_break(_cursvar.orgcbr);    /* restore original ^BREAK status */
	return( OK );
}
