#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef NDEBUG
char *rcsid__setfont = "$Header: c:/curses/private/RCS/_setfont.c%v 2.0 1992/11/15 03:24:36 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_set_font()	- sets the current font size

  PDCurses Description:
 	This is a private PDCurses function.

 	This routine sets the current font size, if the adapter allows
 	such a change.

  PDCurses Return Value:
 	This function returns OK upon success otherwise ERR is returned.

  PDCurses Errors:
 	It is an error to attempt to change the font size on a "bogus"
 	adapter.  The reason for this is that we have a known video
 	adapter identity problem.  e.g. Two adapters report the same
 	identifying characteristics.

 	It is also an error to attempt to change the size of the Flexos
 	console (as there is currently no support for that).

  Portability:
 	PDCurses	int	PDC_set_font( int size );

**man-end**********************************************************************/

int	PDC_set_font(int size)
{
#ifdef	FLEXOS
	return( ERR );
#endif
#ifdef	DOS
	if (_cursvar.bogus_adapter)
		return( ERR );

	switch (_cursvar.adapter)
	{
	case _CGA:
	case _MDA:
	case _MCGACOLOR:
	case _MCGAMONO:
	case _MDS_GENIUS:
		break;

	case _EGACOLOR:
	case _EGAMONO:
		if (_cursvar.sizeable && (_cursvar.font != size))
		{
			switch (size)
			{
			case _FONT8:
				regs.h.ah = 0x11;
				regs.h.al = 0x12;
				regs.h.bl = 0x00;
				int86(0x10, &regs, &regs);
				break;
			case _FONT14:
				regs.h.ah = 0x11;
				regs.h.al = 0x11;
				regs.h.bl = 0x00;
				int86(0x10, &regs, &regs);
				break;
			default:
				break;
			}
		}
		break;

	case _VGACOLOR:
	case _VGAMONO:
		if (_cursvar.sizeable && (_cursvar.font != size))
		{
			switch (size)
			{
			case _FONT8:
				regs.h.ah = 0x11;
				regs.h.al = 0x12;
				regs.h.bl = 0x00;
				int86(0x10, &regs, &regs);
				break;
			case _FONT14:
				regs.h.ah = 0x11;
				regs.h.al = 0x11;
				regs.h.bl = 0x00;
				int86(0x10, &regs, &regs);
				break;
			case _FONT16:
				regs.h.ah = 0x11;
				regs.h.al = 0x14;
				regs.h.bl = 0x00;
				int86(0x10, &regs, &regs);
				break;
			default:
				break;
			}
		}
		break;
	default:
		break;
	}
	if (_cursvar.visible_cursor)
		curson();
	else
		cursoff();
	_cursvar.font = PDC_get_font();
	return( OK );
#endif
#ifdef	OS2
	VIOMODEINFO modeInfo;
	if (_cursvar.sizeable && (_cursvar.font != size))
	{
	       modeInfo.cb = sizeof(modeInfo);
	       /* set most parameters of modeInfo */
	       VioGetMode(&modeInfo, 0);
	       modeInfo.cb = 8;     /* ignore horiz an vert resolution */
               modeInfo.row = modeInfo.vres / size;
	       VioSetMode(&modeInfo, 0);
	}
	if (_cursvar.visible_cursor)
		curson();
	else
		cursoff();
	_cursvar.font = PDC_get_font();
	return( OK );
#endif
}
