#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__setcrsr = "$Header: c:/curses/private/RCS/_setcrsr.c%v 2.0 1992/11/15 03:24:36 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_set_cursor_mode()	- Set the cursor start and stop scan lines.

  PDCurses Description:
 	Sets the cursor type to begin in scan line startrow and end in
 	scan line endrow.  Both values should be 0-31.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_set_cursor_mode( int startrow, int endrow );

**man-end**********************************************************************/

int	PDC_set_cursor_mode( int startrow, int endrow )
{
#ifdef	FLEXOS
	/*
	 * Under FLEXOS, this routine translates the input parameters in the
	 * following way:
	 *
	 * startrow --> visible_cursor endrow	 -->	cursor type:
	 * underline = 0; block = 1;
	 *
	 * VCWM_CURSOR	   0x0100	   bit - 8 Cursor off VCWM_BLOCK	
	 * 0x0200	   bit - 9 Block Cursor	
	 *
	 */
	unsigned short mybuff = 0;

	retcode = s_getfield(T_VIRCON, VC_MODE, 1L, (void far *) &mybuff, 2L);
	if (retcode < 0L)
		return( ERR );
	if (startrow)
		mybuff &= ~VCWM_CURSOR;
	else
		mybuff |= VCWM_CURSOR;

	if (endrow)
		mybuff |= VCWM_BLOCK;
	else
		mybuff &= ~VCWM_BLOCK;

	retcode = s_setfield(T_VIRCON, VC_MODE, 1L, (void far *) &mybuff, 2L);
	return( (retcode < 0L) ? ERR : OK );
#endif
#ifdef	DOS
	regs.h.ah = 0x01;
	regs.h.ch = (unsigned char) startrow;
	regs.h.cl = (unsigned char) endrow;
	int86(0x10, &regs, &regs);
	return( OK );
#endif
#ifdef	OS2
	VIOCURSORINFO cursorInfo;

	cursorInfo.yStart = startrow;
	cursorInfo.cEnd = endrow;
	cursorInfo.cx = 1;
	cursorInfo.attr = 0;
	return (VioSetCurType (&cursorInfo, 0) == 0);
#endif
}
