#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	curson

#ifndef	NDEBUG
char *rcsid_curson = "$Header: c:/curses/nonport/RCS/curson.c%v 2.0 1992/11/15 03:18:26 MH Rel $";
#endif




/*man-start*********************************************************************

  curson()	- Turns on the hardware cursor.

  PDCurses Description:
 	Turns on the hardware curses, it does nothing if it is already on.

  PDCurses Return Value:
 	Returns OK upon success, ERR upon failure.

  Portability:
 	PDCurses	int curson( void );

**man-end**********************************************************************/

int	curson(void)
{
	if	(!_cursvar.visible_cursor)
	{
		_cursvar.visible_cursor = TRUE;
/*		PDC_fix_cursor(_cursvar.orig_emulation);*/
		if (_cursvar.bogus_adapter)
		{
			PDC_set_cursor_mode((_cursvar.cursor & 0xff00) >> 8,
				     (_cursvar.cursor & 0x00ff));
		}
		else
		{
#ifdef     OS2
			PDC_set_cursor_mode((_cursvar.cursor & 0xff00) >> 8,
					     (_cursvar.cursor & 0x00ff));
#else
			switch (_cursvar.adapter) {
			case _MDA:
			case _CGA:
			case _EGACOLOR:
			case _EGAMONO:
			case _VGACOLOR:
			case _VGAMONO:
			case _MDS_GENIUS:
/*				PDC_set_cursor_mode(_cursvar.font - 2, _cursvar.font - 1);*/
				PDC_set_cursor_mode((_cursvar.cursor & 0xff00) >> 8,
					     (_cursvar.cursor & 0x00ff));
				break;
			case _MCGACOLOR:
			case _MCGAMONO:
/*				PDC_set_cursor_mode(_cursvar.font - 1, _cursvar.font - 2);*/
				PDC_set_cursor_mode((_cursvar.cursor & 0xff00) >> 8,
					     (_cursvar.cursor & 0x00ff));
				break;
			case _FLEXOS:
				PDC_set_cursor_mode(_cursvar.visible_cursor, 0);
				break;
			default:
				break;
			}
#endif
		}
	}
	return( OK );
}
