program logger;
{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R-,S+,V+}
{$M 4096,0,0}

{ Program to log all stdout and stderr output of any (?) program to a file.
  Useful when you want to record the output of a program that is being
  spawned by another one.  Works with both .COM and .EXE files.  Could
  easily be modified to redirect other handles (0=stdin, 1=stdout,
  2=stderr, 3=stdaux, 4=stdprt).

  Instructions:
  Move the original program to a directory that's not on the PATH.  Use
  \LOGPROGS, or store the name of the directory actually used in the
  environment variable "LOGPROGS".

  Rename LOGGER.EXE to the name of the program to log.  When invoked, it
  will write an entry to the file named in the environment variable LOGFILE
  (default is LOGGER.LOG in the current directory), then invoke the original
  program.  All output from the original program that would have gone through
  DOS to the console will be logged to the same file.

  If used with DOS 2, the name as well as the path to the original program
  must be given in the environment variable LOGPROGS, since LOGGER won't be
  able to figure out what name you called it.

  Written by Duncan Murdoch for the public domain.  Send comments to me
  at:
     Compuserve    71631,122
     Internet      dmurdoch@watstat.waterloo.edu
     Fidonet       dj murdoch at 1:221/177.40
}
uses
  dos,
  envunit; { N.B. "envunit" is from the excellent package TPENV, by
                  Mike Babulic, and available in the BPROGA forum
                  on Compuserve. }

const
  stdout = 1;
  stderr = 2;

var
  logfilename : pathstr;
  logfile : text;
  execfilename : pathstr;
  exitcode : integer;

procedure force_dup(existing,second:word);
var
  r:registers;
begin
  r.ah := $46;
  r.bx := existing;
  r.cx := second;
  msdos(r);
  if (r.flags and fcarry) <> 0 then
    writeln(logfile,'Error ',r.ax,' changing handle ',second);
end;

procedure timestamp;
const
  monthname:array[1..12] of string[3] =
  ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
var
  year,month,day,dayofweek,hour,minute,second,sec100:word;
begin
  getdate(year,month,day,dayofweek);
  gettime(hour,minute,second,sec100);
  write(logfile,
                day:2,' ',monthname[month],year mod 100:3,
                hour:3,':',minute:2,':',second:2,' ');
end;

begin
  { Open the log file }
  logfilename := getenv('LOGFILE');
  if logfilename = '' then
    logfilename := 'LOGGER.LOG';

  assign(logfile,logfilename);
  if fileexists(logfilename) then
    {$i-} append(logfile) {$i+}
  else
    {$i-} rewrite(logfile); {$i+}

  if ioresult <> 0 then
  begin
    writeln('Logger can''t open logfile!!!! Aborting.');
    halt(99);
  end;

  timestamp;

  { Redirect STDOUT and STDERR }

  force_dup(textrec(logfile).handle,stdout);
  force_dup(textrec(logfile).handle,stderr);

  { Find and invoke the real program }

  execfilename := getenv('LOGPROGS');
  if execfilename <> '' then
  begin
    if not fileexists(execfilename) then
    begin
      if execfilename[length(execfilename)] <> '\' then
        execfilename := execfilename + '\';
      execfilename := execfilename + myname + myext;
    end;
  end
  else  { no environment string }
  begin
    execfilename := '\LOGPROGS\' + myname + myext;
  end;

  if not fileexists(execfilename) then
  begin
    writeln(logfile,'LOGGER unable to find ',execfilename,' to execute!');
    exitcode := 1;
  end
  else
  begin
    writeln(logfile,'LOGGER executing ',execfilename,' ',paramstring);
    flush(logfile);
    {$ifdef ver50}
    swapvectors;
    {$endif}
    exec(execfilename,paramstring);
    {$ifdef ver50}
    swapvectors;
    {$endif}
    exitcode := dosexitcode;
    writeln(logfile);
    timestamp;
    writeln(logfile,'LOGGER received exit code ',exitcode);
  end;
  close(logfile);
  halt(exitcode);
end.
