DEFINT A-Z
'+==================================================================+
'|                           VIDTOOLS.BAS                           |
'|                                                                  |
'|  A set of video routines developed by Larry Stone and the SWOCC  |
'|  students of Larry Stone, CS133B, Fall Term '91, SWOCC.          |
'+------------------------------------------------------------------+
'
'---- Declare Type used for passing arguments to the Box subroutine
TYPE Frame
    boxType AS INTEGER
    fore    AS INTEGER
    back    AS INTEGER
    filClr  AS INTEGER
    lftCol  AS INTEGER
    rgtCol  AS INTEGER
    tRow    AS INTEGER
    bRow    AS INTEGER
END TYPE

DECLARE FUNCTION GetMonitorSeg% ()

CONST True = -1, False = 0

'+==================================================================+
'|                            SUBPROGRAMS                           |
'+------------------------------------------------------------------+

'+==================================================================+
'|                          Box Subprogram                          |
'|                                                                  |
'|  Purpose:  Creates a frame, clearing the center with the desired |
'|            fill color unless Frame.filClr is 255, in which case  |
'|            the frame is created without clearing the center area |
'|            of the box.                                           |
'|                                                                  |
'|  Input:  TYPEd structured variable, Frame DIMmed as Frame.       |
'|                                                                  |
'|          Frame.BoxType  -  INTEGER variable 1 to 4               |
'|                      Ŀ      ͻ       ͸       ķ        |
'|                 1 =    2 = ͼ   3 = ;   4 = Ľ        |
'|                                                                  |
'|          Frame.fore     -  INTEGER variable, forground color     |
'|          Frame.Back     -  INTEGER variable, background color    |
'|          Frame.filClr   -  INTEGER variable, fill color          |
'|                            (if filClr = 255 then no fill)        |
'|          Frame.lftCol   -  INTEGER variable, left column of box  |
'|          Frame.rgtCol   -  INTEGER variable, right column of box |
'|          Frame.tRow     -  INTEGER variable, top row of box      |
'|          Frame.bRow     -  INTEGER variable, bottom row of box   |
'|                                                                  |
'|  Subprogram variables:                                           |
'|                                                                  |
'|          ul  -  Upper left corner character as ASCII INTEGER     |
'|          ll  -  Lower left corner character as ASCII INTEGER     |
'|          ur  -  Upper right corner character as ASCII INTEGER    |
'|          lr  -  Lower right corner character as ASCII INTEGER    |
'|          vert - Vertical character as ASCII INTEGER value        |
'|          horz - Horizontal character as ASCII INTEGER value      |
'|          wide - INTEGER Distance between sides of box            |
'+------------------------------------------------------------------+
SUB Box (Frame AS Frame)

    '---- Define corner, vertical and horzizontal characters as INTEGERS
    SELECT CASE Frame.boxType
        CASE 1
            ul = 218: ll = 192: ur = 191: lr = 217
            vert = 179: horz = 196
        CASE 2
            ul = 201: ll = 200: ur = 187: lr = 188
            vert = 186: horz = 205
        CASE 3
            ul = 213: ll = 212: ur = 184: lr = 190
            vert = 179: horz = 205
        CASE 4
            ul = 214: ll = 211: ur = 183: lr = 189
            vert = 186: horz = 196
        CASE ELSE
            PRINT "Undefined BoxType argument"
            END
    END SELECT

    '---- Define distance between box sides
    wide = Frame.rgtCol - Frame.lftCol - 1

    COLOR Frame.fore, Frame.back                    'Set box color
    LOCATE Frame.tRow, Frame.lftCol                 'Locate top row left col
    PRINT CHR$(ul); STRING$(wide, horz); CHR$(ur)   'Print box top

    FOR N = Frame.tRow + 1 TO Frame.bRow - 1        'Loop through box sides
        LOCATE N, Frame.lftCol: PRINT CHR$(vert);   'Print left side
       
        IF Frame.filClr <> 255 THEN                 'If fill color requested
            COLOR Frame.fore, Frame.filClr          'Set fill color
            PRINT SPACE$(wide);                     'Fill between sides
            COLOR Frame.fore, Frame.back            'Reset box color
        END IF
       
        LOCATE N, Frame.rgtCol: PRINT CHR$(vert);   'Print right side of box
    NEXT                                            'Cook until done
          
    LOCATE Frame.bRow, Frame.lftCol                 'Locate box bottom left col
    PRINT CHR$(ll); STRING$(wide, horz); CHR$(lr);  'Print box bottom

END SUB

'+==============================================================+
'|                    GetMonitorSeg% FUNCTION                   |
'|                                                              |
'|  Input:  Nothing                                             |
'|  Return: The function returns an integer representing the    |
'|          segment of memory used to store the video map.      |
'|  Note:   Monochrome systems will return &HB000               |
'|          Color video cards will return &HB800                |
'+--------------------------------------------------------------+
FUNCTION GetMonitorSeg%

    DEF SEG = False
    IF (PEEK(&H410) AND &H30) = &H30 THEN GetMonitorSeg% = &HB000 ELSE GetMonitorSeg% = &HB800
    DEF SEG

END FUNCTION

