' ===========================================================================
'   MODULE: RODENT.BAS
'
'   Demonstartion of the Microsoft (tm) Compatible Mouse Driver for
'   QuickBASIC 4.5
'
'           Copyright (c) 1991
'           Daniel R. Berry (Traveller Software)
'           All Rights Reserved
'
'   This code is released to the Public Domain for distribution with the
'   QBNews.
'
'   Daniel R. Berry
'   3110-C S. Gen McMullen
'   San Antonio, TX  78226
'
'   To start:  QB RODENT /L QB
'
' ===========================================================================
'
'   $INCLUDE: 'MOUSE.BI'
'
DECLARE SUB CPrint (Row%, Col%, Fore%, Back%, Prompt$)
DECLARE SUB ShortDelay (SDelay%)
DECLARE SUB MouseCheck (Flag%)
DECLARE SUB MouseInformation (MouseVer$, MouseType%, MouseType$)
DECLARE SUB MouseLimitsRC (Row1%, Col1%, Row2%, Col2%)
DECLARE SUB MouseMotion (Horz%, Vert%)
DECLARE SUB MouseOn ()
DECLARE SUB MouseStatusRC (Left%, Right%, Row%, Col%)
DEFINT A-Z
'
'   Determine if mouse is available
'
	Flag = -1: CALL MouseCheck(Flag)
	IF Flag <> 1 THEN
		COLOR 15, 1: CLS
		CALL CPrint(5, 0, 30, 1, "Unable to continue - Mouse Driver Software not found!")
		CALL CPrint(7, 0, 12, 1, "Program....Halted")
		COLOR 15, 1
		BEEP: END
	END IF
'
'   Get some information about the mouse
'
	CALL MouseInformation(MouseVer$, MouseType%, MouseType$)
'
'    Setup the Screen - Draw Box
'
	COLOR 15, 1: CLS
	PRINT CHR$(201); STRING$(78, 205); CHR$(187);
	FOR X = 2 TO 14
		PRINT CHR$(186); SPACE$(78); CHR$(186);
	NEXT
	PRINT CHR$(200); STRING$(78, 205); CHR$(188);
	'
	'   Fill it in
	'
		FOR Y = 2 TO 14
			CALL CPrint(Y, 2, 15, 1, STRING$(78, CHR$(249)))
		NEXT
'
'   Place the information items on the screen
'
	CALL CPrint(17, 0, 0, 1, "Mouse Driver Version: " + MouseVer$ + SPACE$(5) + "Mouse Type: " + MouseType$)

	CALL CPrint(16, 23, 0, 1, "Mouse Limits are set within the BOX")
	CALL CPrint(25, 13, 0, 1, "Mouse Interface Demonstration Program By: Daniel R. Berry")
   
	CALL CPrint(19, 4, 15, 1, "Mouse Row:")
	CALL CPrint(20, 4, 15, 1, "Mouse Col:")
  
	CALL CPrint(19, 24, 15, 1, "Horizontal Motion:")
	CALL CPrint(20, 24, 15, 1, "Vertical Motion:")
   
	CALL CPrint(19, 56, 15, 1, "Left Button:")
	CALL CPrint(20, 56, 15, 1, "Right Button:")
'
'   Place the information box on the screen
'
	LOCATE 22, 1
	PRINT CHR$(201); STRING$(78, 205); CHR$(187);
		PRINT CHR$(186); SPACE$(78); CHR$(186);
	PRINT CHR$(200); STRING$(78, 205); CHR$(188);
   
	LOCATE 23, 24: PRINT "Depress both Mouse buttons to EXIT"
	'
	'   Set the mouse limits to stay in Box
	'
		CALL MouseLimitsRC(2, 2, 14, 79)
		CALL MouseOn ' Show us the Mouse
'
'   This is the main loop for the demonstration program.  Here we will
'   determine various information about the mouse and tell the user what
'   is going on.
'
DEMOLoop:
	CALL MouseStatusRC(Left, Right, Row, Col)
	CALL MouseMotion(Horz, Vert)

	Horz$ = "Still"
	IF Horz <> 0 THEN
		IF Horz < 0 THEN Horz$ = "Left " ELSE Horz$ = "Right"
	END IF
	Vert$ = "Still"
	IF Vert <> 0 THEN
		IF Vert < 0 THEN Vert$ = "Up   " ELSE Vert$ = "Down "
	END IF
	MLeft$ = "Normal   ": IF Left < 0 THEN MLeft$ = "Depressed"
	MRight$ = "Normal   ": IF Right < 0 THEN MRight$ = "Depressed"

	CALL CPrint(19, 15, 15, 1, RIGHT$("0" + LTRIM$(STR$(Row)), 2))
	CALL CPrint(20, 15, 15, 1, RIGHT$("0" + LTRIM$(STR$(Col)), 2))
   
	CALL CPrint(19, 43, 15, 1, Horz$)
	CALL CPrint(20, 43, 15, 1, Vert$)
			 
	CALL CPrint(19, 70, 15, 1, MLeft$)
	CALL CPrint(20, 70, 15, 1, MRight$)
'
'   If both buttons depressed then exit program
'
	IF Left < 0 AND Right < 0 THEN
			CALL MouseCheck(-2) ' Disable Mouse
			CALL CPrint(23, 0, 15, 1, SPACE$(60))
			CALL CPrint(23, 0, 12, 1, "Program....Halted")
			COLOR 15, 1
			CALL ShortDelay(100) ' Pause
			END
		ELSE
	'
	'   The delay is to give the user time to see the mouse status
	'
			CALL ShortDelay(10): GOTO DEMOLoop
	END IF

