' =======================================================
'  S&B4EGA.BAS  Copyright (c) 1990  Michael Welch
'  included with GrafWiz by permission
' =======================================================
'  Name:  S&B4EGA.BAS - Sticks and Boxes for EGA
'  Type:  Main Module
'  Lang:  Microsoft QuickBASIC v4.5
'  Ver:   1.10
'  Date:  10/15/1990
'  By:    Michael Welch of Dallas, Texas
'  Reqs:  Crescent Software's PDQ.LIB
'         Tom Hanlin's Graphics Wizard library
'  Purp:  (multifaceted):
'         1.  To demonstrate the efficiency of Crescent's
'             BCOMxx replacement library for QuickBASIC.
'         2.  To demonstrate the capabilities and the
'             extensions of Tom Hanlin's Graphics Wizard
'             replacement graphics library.
'         3.  To demonstrate the color range of the EGA's
'             higher-resolution mode.
'| Mods:  Thomas G. Hanlin III
'|        My modifications were largely a matter of
'|        reformatting the source to appear more like
'|        the other GRAFWIZ sources, for consistency.
'|        A few other trivial alterations were made.
' =======================================================

DECLARE FUNCTION PDQRand% (Range%)     ' PDQ replacement for RND
DECLARE SUB PDQRandomize (Seed%)       ' PDQ replacement for RANDOMIZE

   REM $INCLUDE: 'GRAFWIZ.BI'
   '              ^----------- Tom Hanlin's Graphics Wizard library

   DEFINT A-Z                          ' does not need floating point math

   GetDisplay Adapter, Mono            ' check adapter type
   IF Adapter < 4 THEN                 ' just end if less than EGA
      PRINT "Sorry, you need an EGA or VGA for this demo!"
      END
   END IF

   DEF SEG = 0
   z = PEEK(&H41C) + PEEK(&H41D) * 256
   PDQRandomize z                      ' RANDOMIZE based on system timer

   G9Mode 2                            ' SCREEN 9 replacement

   ' Draw a large multi-colored box using
   ' Tom's replacement for the LINE statement
   FOR Y = 1 TO 63
      G9Color Y AND 15, 0              ' implementation of COLOR
      G9Box Y, Y, 639 - Y, 349 - Y, (Y = 100)
   NEXT

   ' Next, draw the text in the center
   ' of the box.  This is the intro screen
   ' and isn't really needed for the demo,
   ' though it does demonstrate quick graphics
   ' text printing and the G#Banner extra!
   G9Color 19, 15
   G9Banner "S&B4EGA", 70, 70, 9, 10   ' GRAFWIZ "extra" (nice!)
   G9Color 5, 0
   G9Locate 12, 11
   G9WriteLn "An EGA-only demo using Tom Hanlin's Graphics Wizard Library"
   G9Locate 13, 11
   G9WriteLn "and Crescent Software's PDQ Library.  Written by Mike Welch."
   G9Color 14, 0
   G9Locate 14, 11
   G9WriteLn "Proudly compiled with Microsoft's QuickBASIC compiler v4.50"
   G9Color 2, 0
   G9Banner "Any Key Continues", 115, 235, 3, 6

   DO: LOOP UNTIL LEN(INKEY$)          ' loop until keypress


   ' The following is the main part of the demo.
   ' In the first loop (where i = 1) we just draw colorful
   ' high-resolution EGA lines in a random order.  PDQ's
   ' more versatile implementation of RANDOMIZE and RND
   ' are used to generate the coordinates and colors of
   ' the lines.  In the second part, we add a sort of
   ' animation feature to the line drawing by erasing
   ' (overwriting a line in black) the third line, or
   ' "tail" if you will.  In the last loop (i = 3), we
   ' just draw a series of fast high-resolution boxes.
   FOR i = 1 TO 3                      ' really, three different demos
      G9Cls                            ' GRAFWIZ CLS replacement
      G9Locate 25, 32
      G9Write "Any key continues"
      DO                               ' loop until keypress
         z = z + 1                     ' count times looped
         IF z > 1024 THEN              ' if looped 1024 times
            G9Cls                      ' clear the cluttered screen
            G9Locate 25, 32
            G9Write "Any key continues"
            z = 0                      ' reset counter
         END IF
         X2 = PDQRand(639)             ' get random X coordinate
         Y2 = PDQRand(335)             ' get random Y coordinate
         c = PDQRand(15)               ' get random color value
         G9Color c, 0                  ' set color
         IF i = 1 THEN                 ' if this is part 1 of demo
            G9Line X1, Y1, X2, Y2      ' draw a line
         ELSEIF i = 2 THEN             ' if part 2 of demo (animation)
            G9Line X1, Y1, X2, Y2      ' draw a line
            G9Color 0, 0               ' set color to black on black
            G9Line Xo, Yo, X1, Y1      ' erase the tail ("animation")
            G9Color 2, 0               '
            Xo = X1                    ' save old X and Y coordinates
            Yo = Y1                    ' for future "erasure"
         ELSE                          ' part 3 of demo
            G9Box X1, Y1, X2, Y2, 0    ' draw multiple boxes
         END IF
         X1 = X2                       ' save last coordinates such that
         Y1 = Y2                       ' the lines are connected
      LOOP UNTIL LEN(INKEY$)           ' and loop
      z = 0                            ' reset loop counter here
   NEXT

   ' Thanks to my friend Earl Montgomery
   ' who gave me the idea for this next
   ' demo.  The addition of this portion
   ' marks v1.10 of S&B4EGA.
   Switch = -1                         ' initialize function switch
   FOR k = 2 TO 4 STEP 2               ' loop twice, increment in DO below
      Yo = 0: Xo = 0                   ' initialize all vars used in loop
      X1 = 0: Y1 = 0
      i = 0
      Switch = Switch + 1              ' incriment function switch
      G9Cls                            ' clear screen
      G9Locate 25, 32
      G9Write "Any key continues"
      DO UNTIL LEN(INKEY$)             ' loop (twice) until keypress
         EndLoop = 0                   ' reset Boolean flag
         DO                            ' derive legal value for animation
            X1 = X1 + Xo               ' add to x-coord
            Y1 = Y1 + Yo               ' add to y-coord
            z = PDQRand(1)             ' used for animation: binary result
            IF X1 < 16 THEN            ' if under x range
               Xo = z * k              ' enlarge value
            ELSEIF X1 > 624 THEN       ' if over x range
               Xo = 0 - z * k - 1      ' decrease value
            ELSEIF Y1 < 16 THEN        ' if under y range
               Yo = z * k              ' enlarge
            ELSEIF Y1 > 315 THEN       ' if over y range
               Yo = 0 - z * k - 1      ' decrease
            ELSE
               EndLoop = -1            ' quit computing and draw box
            END IF
         LOOP UNTIL EndLoop

         c = c + 1                     ' increase color counter
         IF c > 63 THEN c = 1          ' reset if out of range


         i = i + 1                     ' increment loop counter
         G9Color c, 0                  ' set color here
         IF Switch THEN                ' if on SECOND loop
            IF i > 3072 THEN           ' clear screen
               G9Cls
               G9Locate 25, 32
               G9Write "Any key continues"
               i = 0
            END IF
            G9Box X1 - 15, Y1 + 15, X1 + 15, Y1 - 15, c  ' draw filled box
         ELSE
            G9Box X1 - 15, Y1 + 15, X1 + 15, Y1 - 15, 0  ' draw empty box
            IF i > 6144 THEN           ' clear screen
               G9Cls
               G9Locate 25, 32
               G9Write "Any key continues"
               i = 0
            END IF
         END IF
      LOOP
   NEXT

   G9Mode 0                            ' restore text mode
   PRINT "[2J"                        ' clears to ANSI screen colors
   '      ^---can't print this on printer
