/*	v_startup.c- Start-up and Shut-down the Video System */
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

static int Old_mode = LASTMODE; /* startup video mode, Return to this
                                 * mode when the window system exits.
                                 */
static unsigned Times_called = 0;
/*----------------------------------------------------------------------*/
void v_shutdown ( void )
{
    /* V_shutdown shuts down the video system sometime before the
     * normal shutdown at program termination.
     */

    if( Old_mode != LASTMODE )
    {
        textmode( Old_mode );   /* Restore original mode */
        Old_mode = LASTMODE;
    }
    Times_called = 0;           /* allow a restart */
}

int v_startup( int mode )
{
    /* v_startup is passed either a video mode or LASTMODE, as defined in
     * <conio.h>, if mode==LASTMODE, the current video mode is used.
     *
     * V_startup calls atexit(), so the video system will shut down
     * automatically when the program exits. The video system can
     * be initialized only once. Subsequent calls do nothing & return false
     * unless the video system is shut down explicitly with a
     * v_shutdown() call.
     */

    struct text_info info;

    if( Times_called++ == 0)
    {
        gettextinfo( &info );
        Old_mode = info.currmode;
        if( mode != LASTMODE )
            textmode( mode );
        atexit( v_shutdown );   /* Call v_shutdown on exit */
    }
    return( Times_called == 1 );
}
