/*	v_deacti.c- Deactivate Viewport */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

int v_deactivate( viewport *v, int hide )
{
    /* Vclose() effectively sets the viewport back to its original,
     * pristine condition, as if it had never been opened. vdeactivate()
     * is less thorough. The contents of the window are saved in a local
     * buffer, and if hide is true, the original underlying text is
     * restored. A subsequent vopen() call restores the window to the
     * condition it was in before the vdeactivate.
     */

    if( v->magic != VMAGIC  ||  v->inactive )
        return 0;

    v->inactive = 1;
    if( !v->old_image )
        if( !(v->old_image = VMALLOC(v->nrows*v->ncols*sizeof(int))))
            return 0;
    _v_save_scr( v->old_image, v->row, v->col, v->nrows, v->ncols );

    if( hide && v->savebuf )    /* Restore original text. */
    {
        _v_restore_scr( v->savebuf, v->row, v->col, v->nrows, v->ncols );
        VFREE( v->savebuf );
        v->savebuf = NULL;      /* Set savebuf null to tell v_open to */
    }                           /* save underlying text on reopen.    */
    return 1;
}
