/*	v_open.c- Display Viewport */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

int v_open( viewport *v )
{
    /*  Open (save underlying text and clear underlying region) the viewport.
     *  If clearok is enabled, area under viewport is filled with blanks
     *  the first time the viewport is opened, the behavior of subsequent
     *  calls depends on whether the viewport was closed or deactivated.
     *  If closed and clearok is enabled, the area is filled with blanks.
     *  If deactivated, the area is filled with the previous contents
     *  (at deactivate time). Underlying is saved if saveok is enabled
     *  and (1) this is a new or closed viewport or (2) this is a deactivated,
     *  hidden viewport. The text isn't saved for deactivated, but visible
     *  viewports. All the viewport-manipulation functions will open
     *  the window implicitly if an explicit open hasn't been performed.
     */

    if( v->magic != VMAGIC )
        return 0;

    /* If the window is closed, then it doesn't exist on the screen. Save
     * the underlying text and initialize if required. If it's inactive
     * but not closed, then it still exists on the screen and a refresh
     * is required.
     */

    if( v->closed || v->inactive )
    {
        if( v->saveok && !v->savebuf )
        {
            if( !(v->savebuf = VMALLOC(v->nrows * v->ncols * sizeof(int))))
                return 0;

            _v_save_scr( v->savebuf, v->row, v->col, v->nrows, v->ncols );
        }

        /* Initialize the viewport, either to the original image (before
         * it was deactivated) or to blanks (if clearok is true). If neither
         * condition is true, don't initialize. (I'm assuming that the
         * application will then fill up the window.)
         */

        if( v->inactive && v->old_image )
        {
            _v_restore_scr( v->old_image, v->row, v->col, v->nrows, v->ncols );
            VFREE( v->old_image );
            v->old_image = NULL;
        }
        else if( v->clearok )
            v_clear( v );
    }

    v->closed   = 0;
    v->inactive = 0;
    v_gotorc( v, v->cur_row, v->cur_col );
    return 1;
}
