	title	netbios datagram spy
	include	asm.inc
	include	netbios.inc

	public	main

	.stack

	.const
broadcast_text	db  'Broadcast',0
callname_text	db  ' - Call Name:',0
datagram_text	db  'Datagram ',0
driver_text	db  'No NetBIOS driver found',0
help_text	db  'NetBIOS Spy - displays network datagrams',13,10
		db  'Press ESC to exit',0
length_text	db  ' - Length:',0
retcode_text	db  ' - RetCode:',0
spy_text	db  'Spy',0


	.data?
ncb_broadcast	ncb <>			; control blk for broadcast datagrams
ncb_datagram	ncb <>			; control blk for other datagrams

buf_broadcast	db  DATAGRAM_MAX dup(?)	; buffer for broadcast datagrams
buf_datagram	db  DATAGRAM_MAX dup(?)	; buffer for other datagrams

add_name	db	?


	.code
 extn exit_program,get_input_state,clear_ncb,netbios_call,netbios_cancel
 extn putchar_newline,puts,put_hex_byte,put_hex_word,put_multiple_bytes
 extn put_netbios_name,put_string,startup,netbios_check
 extn netbios_add_name,netbios_delete_name

;;	main
;
main	proc
	lea	si,help_text
	call	puts

	call	netbios_check
	jc	mai4			;  if no netbios driver

	lea	si,spy_text
	call	netbios_add_name
	mov	add_name[bp],al

mai1:	lea	si,ncb_broadcast	; check receive broadcast datagram
	cmp	Ncb_Cmd_Cplt[si],0FFh
	je	mai2			;  if receive pending

	call	clear_ncb		;  else post receive broadcast
	mov	Ncb_Command[si],NB_RECEIVE_BROADCAST
	mov	Ncb_Num[si],0FFh	;  (FF means any datagram)
	mov	Ncb_BufferOff[si],offset buf_broadcast
	mov	Ncb_BufferSeg[si],ds
	mov	Ncb_Length[si],size buf_broadcast
	call	netbios_call

mai2:	lea	si,ncb_datagram		; check receive datagram
	cmp	Ncb_Cmd_Cplt[si],0FFh
	je	mai3			;  if receive pending

	call	clear_ncb		;  else post receive broadcast
	mov	Ncb_Command[si],NB_RECEIVE_DATAGRAM
	mov	al,0FFh			;  (FF means any datagram)
;	mov	al,add_name[bp]
	mov	Ncb_Num[si],al
	mov	Ncb_BufferOff[si],offset buf_datagram
	mov	Ncb_BufferSeg[si],ds
	mov	Ncb_Length[si],size buf_datagram
	call	netbios_call

mai3:	call	get_input_state
	jnz	mai5			;  if key waiting

	lea	si,ncb_broadcast
	call	process_control_block

	lea	si,ncb_datagram
	call	process_control_block
	jmp	mai1

mai4:	lea	si,driver_text		; *No NetBIOS driver found*
	call	puts
	jmp	exit_program

mai5:	lea	si,ncb_broadcast
	call	netbios_cancel
	lea	si,ncb_datagram
	call	netbios_cancel
	lea	si,spy_text
	call	netbios_delete_name
	jmp	exit_program
main	endp


;;	process control block
;
;	entry	DS:SI	datagram control block
;	uses	AX,BX,CX,SI
;
process_control_block proc
	mov	bx,si
	cmp	Ncb_Cmd_Cplt[bx],0FFh
	je	pcb3			;  if receive still pending

	lea	si,datagram_text	; *Datagram *
	cmp	Ncb_Command[bx],NB_RECEIVE_DATAGRAM
	je	pcb1
	lea	si,broadcast_text	; *Broadcast*
pcb1:	call	put_string

	cmp	Ncb_RetCode[bx],0	; display non-zero return code
	je	pcb2

	lea	si,retcode_text		; * - RetCode:*
	call	put_string
	mov	al,Ncb_RetCode[bx]
	call	put_hex_byte

pcb2:	lea	si,length_text		; * - Length:*
	call	put_string
	mov	ax,Ncb_Length[bx]
	call	put_hex_word

	lea	si,callname_text	; * - Call Name:*
	call	put_string

	lea	si,Ncb_CallName[bx]	; display call name
	call	put_netbios_name
	call	putchar_newline

	push	ds			; display datagram
	mov	cx,Ncb_Length[bx]
	lds	si,dword ptr Ncb_BufferOff[bx]
	call	put_multiple_bytes
	pop	ds
pcb3:	ret
process_control_block endp

	end
