        PAGE    ,105
        TITLE   VLABEL Function
        .MODEL  MEDIUM
;***********************************************************************
;                              VLABEL.ASM                              *
;   VLABEL (<drive>) [DECLARE FUNCTION VLABEL$ (A$)] is an assembled   *
; string function to be linked to programs written in Microsoft BASIC  *
; v. 7.0, or later.  When given a valid drive code as an argument, it  *
; returns a string containing the volume label.                        *
;   VLABEL uses the first character of the string argument as the code *
; for the requested drive.  If the disk in that drive has no label (or *
; no such drive exists), VLABEL will return a null string.  If the     *
; code refers to a diskette drive with the door open, the calling      *
; BASIC program will be interrupted with a BASIC "Disk not ready"      *
; error interrupt.                                                     *
;                   Written by M. L. Lesser, 4/27/90                   *
;                 Assembled with Microsoft MASM v. 5.1                 *
;***********************************************************************

        EXTRN StringAddress: FAR
        EXTRN StringAssign:  FAR
        EXTRN StringLength:  FAR
        EXTRN StringRelease: FAR

.DATA
FCB     DB      0FFH                    ;Use extended FCB format to
        DB      5 DUP(0)                ;   avoid unwanted period.
        DB      8                       ;Label attribute
DRIVE   DB      0                       ;Drive code goes here
FLABEL  DB      11 DUP(?)               ;Dummy file name
        DB      21 DUP(?)               ;Remaining FCB filler
DESCRIP DD      0                       ;BASIC string descriptor

.CODE
        PUBLIC VLABEL
VLABEL  PROC
        PUSH    BP
        MOV     BP,SP
        PUSH    DS
        PUSH    DI
        MOV     AH,2FH                  ;Get and save BASIC's DTA
        INT     21H
        PUSH    BX                      ;DTA offset
        PUSH    ES                      ;DTA segment
;  Check for non-null input string (drive code):
        PUSH    6[BP]                   ;Input string descriptor pointer
        CALL    StringLength            ;Get length
        OR      AX,AX                   ;Is it zero?
        JZ      NODRV                   ;If so, skip getting drive code
;  Locate address of input string:
        PUSH    6[BP]
        CALL    StringAddress
        MOV     DS,DX                   ;Move string address to DS:BX
        MOV     BX,AX
        MOV     AL,[BX]                 ;  and drive letter to AL
        AND     AL,5FH                  ;Make drive character upper case
        SUB     AL,40H                  ;Convert to FCB drive code
;  Set up extended FCB to find label:
NODRV:  MOV     BX,SS                   ;Restore DGROUP addressability
        MOV     DS,BX                   ;  to DS and ES
        MOV     ES,BX
        MOV     DRIVE,AL                ;Load drive number in FCB:
        LEA     DI,FLABEL               ;Load FLABEL portion of FCB with
        MOV     AL,'?'                  ;  question marks
        MOV     CX,11
        REP     STOSB
;  Find the first file containing a label (there is only one!):
        LEA     DX,FCB                  ;Set DTA to FCB
        MOV     AH,1AH
        INT     21H
        MOV     AH,11H                  ;Find first
        INT     21H
        OR      AL,AL                   ;Will be zero if label found
        JNZ     NULLIT                  ;If not, send zero-length string
; Decrease CX by count of trailing blanks in label:
        MOV     CX,11
        MOV     AL,' '
        DEC     DI                      ;Restore DI to end of label
        STD                             ;Scan "down"
        REPZ    SCASB
        INC     CX                      ;Include "last" non-blank
        CLD                             ;Restore cleared direction flag
; Convert label to BASIC string
        PUSH    DS                      ;Far address of MASM string
        LEA     AX,FLABEL
        PUSH    AX
        PUSH    CX                      ;Length of string
        PUSH    DS                      ;Far address of descriptor
        LEA     AX,DESCRIP
        PUSH    AX
        XOR     AX,AX                   ;Zero-length copies MASM string
        PUSH    AX                      ; into BASIC string space 
        CALL    StringAssign
DIVOTS: POP     DS                      ;Restore BASIC's DTA
        POP     DX
        MOV     AH,1AH
        INT     21H
        POP     DI                      ;Restore registers
        POP     DS
        POP     BP
        LEA     AX,DESCRIP              ;Return near address to BASIC
        RET     2
NULLIT: LEA     AX,DESCRIP              ;Make BASIC string null
        PUSH    AX
        CALL    StringRelease
        JMP     DIVOTS
VLABEL  ENDP
        END
