/* testrsc.c	test loading, looking-up and printing resource strings.
 */

#include <stdio.h>
#include "testrsc.h"
#include "resources.h"

void	fatal(char *str);

void
main()
{
	StringResource	*res = LoadResources("strings.rsc");
	StringResource	*current;

	if (res == NULL)
		fatal("error loading strings.rsc");

	current = LookUpResource(res, TEST_STRING1);
	printf("TEST_STRING1 = %s\n", GetResourceString(current));

	current = LookUpResource(res, TEST_STRING2);
	printf("TEST_STRING2 = ");
	printf(GetResourceString(current), 1);
	printf("\n");

	current = LookUpResource(res, TEST_STRING3);
	printf("TEST_STRING3 = ");
	printf(GetResourceString(current), "string\n");

	exit(0);
}

void
fatal(char *str)
{
	fprintf(stderr, "fatal: %s\n", str);
	exit(0);
}
