	title	misc - miscellaneous routines for pj82
	include	asm.inc

MALLOC_MAX		equ	0FFF0h	; maximum size of malloc block


	.data
	extw	psp

error_text		dw	0	; asciiz error msg offset in DGROUP

err_no_memory		db	'Out of memory',0
err_too_big		db	'malloc max exceeded',0

	.data?
argc			dw	?
argv			dd	?


	.code
	extn	set_strerror

;;	exit program
;
exit_program proc
	mov	ax,4C00h
	jmp	ms_dos
exit_program endp


;;	exit with error
;
exit_with_error proc
	mov	ax,4C01h
	jmp	ms_dos
exit_with_error endp


;;	free raw
;
;	entry	ES:DI	storage ptr
;	exit	Cf	if bad ptr
;	uses	AX
;
free_raw proc
	mov	ah,49h
	jmp	ms_dos
free_raw endp


;;	malloc raw
;
;	entry	CX	request bytes size (may not exceed 65536-16)
;	exit	ES:DI	storage ptr
;		Cf	if not enough memory available or request too large
;	uses	AX
;
malloc_raw proc
	push	bx
	mov	bx,cx
	add	bx,15
	jc	mar2			; if too much requested
	shr	bx,1
	shr	bx,1
	shr	bx,1
	shr	bx,1

	mov	ah,48h
	call	ms_dos
	jc	mar3			; if not enough memory

	mov	es,ax
	xor	di,di

mar1:	pop	bx
	ret

mar2:	lea	ax,err_too_big
	call	set_strerror
	jmp	mar1
mar3:	lea	ax,err_no_memory
	call	set_strerror
	jmp	mar1
malloc_raw endp


;;	ms dos
;
ms_dos	proc
	int	21h
	ret
ms_dos	endp


;;	read command line
;
;	exit	DS:SI	program command line
;
read_command_line proc
	mov	ds,psp[bp]
	mov	si,81h
	ret
read_command_line endp


;;	read environment
;
;	exit	DS:SI	environment
;
read_environment proc
	xor	si,si
	mov	ds,psp[bp]
	mov	ds,[si+2Ch]
	ret
read_environment endp


;;	set argc argv
;
;	exit	Cf	if no memory
;	uses	AX,CX,DI,SI,ES,DS
;
set_argc_argv proc
	mov	cx,256
	call	malloc_raw
	jc	saa9			; if no memory

	mov	argc[bp],1
	mov	wptr argv[bp],di
	mov	wptr argv[bp+2],es

	mov	ah,30h
	call	ms_dos
	cmp	al,3
	jb	saa10			;  if prior to DOS version 3.x

	call	read_environment	; skip environment
saa1:	call	strskp
	lodsb
	cmp	al,NULL_CHAR
	jne	saa1
	lodsw				;  (skip 1)

	call	strcpy			; copy program name which appears
	inc	di			;  after environment

saa2:	call	read_command_line
saa3:	call	strskp_white
	cmp	al,CR_CHAR
	je	saa7			; if no more arguments

	inc	argc[bp]
	jmp	saa5
saa4:	stosb
saa5:	lodsb
	cmp	al,SPACE_CHAR
	jbe	saa6
	cmp	al,','
	je	saa6
	cmp	al,'~'
	jbe	saa4

saa6:	cmp	al,CR_CHAR
	mov	al,NULL_CHAR
	stosb
	jne	saa3

saa7:	inc	di			; word align table
	and	di,-2

	lds	si,argv[bp]		; get ptr to first argument
	mov	wptr argv[bp],di	; set pointer list offset
	mov	cx,argc[bp]		; get list count (cannot==0)

saa8:	mov	ax,si			; build pointer list
	stosw
	call	strskp
	loop	saa8
	clc
saa9:	ret

saa10:	mov	ax,'C'
	stosw
	jmp	saa2
set_argc_argv endp


;;	strcpy
;
;	entry	DS:SI	source ptr
;		ES:DI	destination ptr
;	exit	SI	updated past NULL
;		DI	updated, points to NULL
;	uses	AX
;
strcpy	proc
	lodsb
	stosb
	cmp	al,NULL_CHAR
	jne	strcpy
	dec	di
	ret
strcpy	endp


;;	strskp
;
;	entry	DS:SI	asciiz string ptr
;	exit	SI	updated past null
;	uses	AX
;
strskp	proc
	lodsb
	cmp	al,NULL_CHAR
	jne	strskp
	ret
strskp	endp


;;	strskp white
;
;	entry	DS:SI	text ptr
;	exit	SI	updated past spaces and tabs
;		AL	non-white character
;
strskp_white proc
	lodsb
	cmp	al,SPACE_CHAR
	je	strskp_white
	cmp	al,TAB_CHAR
	je	strskp_white
	dec	si
	ret
strskp_white endp

 public	error_text,err_no_memory,err_too_big
 public argc,argv,exit_program,exit_with_error
 public free_raw,malloc_raw,ms_dos,read_command_line
 public read_environment,set_argc_argv,strcpy,strskp,strskp_white

	end
