/*
 * wintest.c	test the curses window stacking.  winPush and winPop
 *		implement trivial window stacking.  for instance, you
 *		can only pop the most recently pushed window.
 */

#include <curses.h>
#include "winstack.h"

main()
{
	initscr();
	noecho();
	nonl();
	raw();

	/** since you ultimately need a bottom window
	 ** to clear all other windows, you should always
	 ** use stdscr or some other full screen window
	 ** as the bottom window.
	 **/

	winPush( stdscr );

	stackem();

	endwin();
	exit(0);
}

stackem()
{
	WINDOW *w1, *w2, *w3;

	w1 = newwin(20, 60, 2, 5);
	w2 = newwin(LINES, 15, 0, 40);
	w3 = newwin(5, COLS, 10, 0);

	box(w1, 0, 0);
	mvwaddstr(w1, 0, 2, " Window 1 ");
	winPush( w1 );
	getch();

	box(w2, 0, 0);
	mvwaddstr(w2, 0, 2, " Window 2 ");
	winPush( w2 );
	getch();

	box(w3, 0, 0);
	mvwaddstr(w3, 0, 2, " Window 3 ");
	winPush( w3 );
	getch();

	winPop();
	getch();
	winPop();
	getch();
	winPop();
}
