{GRWDemo.pas Copyright (C) 1989 by Gene Fowler

GRWDemo.pas is a stripped down 3-D object
rotator and translator to be compiled in Turbo
Pascal 5.0 using crt, graph, and graphWld. It
uses three GraphWld procedures: CreateWorld in
InitWorld; WLine in ConstructModel; and w2vp
in WritePressKey.
}
program GraphWldDemo;

uses crt, graph, graphwld;

type
   ObjectVertex = record
                     x, y, z : real
                  end;
   WorldObj     = Array[0..5] of ObjectVertex;     {world coords}
   ViewObj      = Array[0..5] of ObjectVertex;     {view coords }
   ScreenVertex = record
                     sx, sy : Real
                  end;
   DisplayObj   = Array[0..5] of ScreenVertex;     {display coords}

var
   {BGI Init and other control variables}
   gdriver, gmode, ecode : integer;
   MaxX, MaxY : integer;
   MaxColor : word;
   ViewP : ViewPortType;
   GoAgain : char;

   {The Array variables}
   WObj   : WorldObj;
   VObj   : ViewObj;
   DObj   : DisplayObj;

   {3-D drawing variables}
   Dist : Real;
   YawDeg, RollDeg, PitchDeg,
   YawRad, RollRad, PitchRad,
   SinYawRad, CosYawRad, SinRollRad,
   CosRollRad, SinPitchRad, CosPitchRad,
   TransX, TransY, TransZ : Real;

   {work variables for calculations}
   x, y, z, xa, ya, za,
   x1, x2, x3, x4, y1, y2, y3, y4,
   z1, z2, z3, z4,
   sx, sy : Real;
   i : byte;

   {VAR params for the w2vp translation procedure in GraphWld.tpu}
   wx, wy   : real;
   vpx, vpy : integer;

procedure AdjustParams;   {for use in rotation calcs}
begin
  SinYawRad := Sin(YawRad); CosYawRad := Cos(YawRad);
  SinRollRad := Sin(RollRad); CosRollRad := Cos(RollRad);
  SinPitchRad := Sin(PitchRad); CosPitchRad := Cos(PitchRad)
end;

procedure CalcVandDArrays;
begin
   For i := 0 to 5 do
     begin
       x:= WObj[i].x; y:= WObj[i].y; z:= WObj[i].z;
       x  := (-1)*x;
       xa := CosYawRad*x - SinYawRad*z;
       za := SinYawRad*x + CosYawRad*z;
       x  := CosRollRad*xa + SinRollRad*y;
       ya := CosRollRad*y - SinRollRad*xa;
       z  := CosPitchRad*za - SinPitchRad*ya;
       y  := SinPitchRad*za + CosPitchRad*ya;
       x  := x + TransX; y := y + TransY; z := z + TransZ;
       sx := Dist*x/z; sy := Dist*y/z;
       VObj[i].x := x; VObj[i].y := y; VObj[i].z := z;
       DObj[i].sx := sx; DObj[i].sy := sy
     end
end;

procedure ConstructModel;

begin
   CalcVandDArrays;
   SetColor(MaxColor);
   SetLineStyle(0,0,1);

   {Surface 0 }
   x1 := DObj[0].sx; y1 := DObj[0].sy; x2 := DObj[1].sx; y2 := DObj[1].sy;
   x3 := DObj[2].sx; y3 := DObj[2].sy; x4 := DObj[3].sx; y4 := DObj[3].sy;
   WLine(x1,y1,x2,y2);  {In GraphWld: translates params, calls Line}
   WLine(x2,y2,x3,y3);
   WLine(x3,y3,x4,y4);
   WLine(x4,y4,x1,y1);

   {Surface 1}
   x1 := DObj[1].sx; y1 := DObj[1].sy; x2 := DObj[4].sx; y2 := DObj[4].sy;
   x3 := DObj[5].sx; y3 := DObj[5].sy; x4 := DObj[2].sx; y4 := DObj[2].sy;
   WLine(x1,y1,x2,y2);  {In GraphWld: translates params, calls Line}
   WLine(x2,y2,x3,y3);
   WLine(x3,y3,x4,y4);  {Note: don't REDRAW a line to close surface}
end; {ConstructModel}

procedure WritePressKey;
begin
   SetTextstyle(DefaultFont,HorizDir,1);
   wx := 200; wy := 250;
   w2vp(wx,wy,vpx,vpy);                   {uses standalone translator}
   OutTextXY(vpx,vpy,'press any key...')
end;

function Deg2Rad(Degs : Real) : Real;
begin
   Deg2Rad := Degs * 0.01745327778
end;

procedure InitWorld;  {also inits graphics, program}
begin
   gdriver := Detect;
   InitGraph(gdriver, gmode,'a:\');
   ecode := GraphResult;
   if ecode <> 0 then
     begin
       writeln('Halted on graphics error: ', GraphErrorMsg(ecode));
       Halt(2)
     end;
   SetGraphMode(GetGraphMode);
   MaxColor := GetMaxColor;
   MaxX := GetMaxX;
   MaxY := GetMaxY;
   SetViewPort(0,0,MaxX,MaxY,ClipOn);
   {See Note in header about "finagling" your world!}
   CreateWorld(-399.0,-299.0,400.0,300.0); {after setting viewport}
(* CreateWorld(-399.0,300.0,400.0,-299.0); {"flipped" world}  *)

  {---Initialize DataBase---}
  WObj[0].x :=  30; WObj[0].y := -30; WObj[0].z := 0;
  WObj[1].x :=  30; WObj[1].y :=  30; WObj[1].z := 0;
  WObj[2].x := -30; WObj[2].y :=  30; WObj[2].z := 0;
  WObj[3].x := -30; WObj[3].y := -30; WObj[3].z := 0;
  WObj[4].x :=  30; Wobj[4].y :=  30; Wobj[4].z := -60;
  Wobj[5].x := -30; WObj[5].y :=  30; WObj[5].z := -60;

  {---assign drawing variables---}
  Dist := 1200;    {distance to picture plane}
  {YawRad := Deg2Rad(0); RollRad := Deg2Rad(0); PitchRad := Deg2Rad(0);}
  TransX := 0; TransY := 0; TransZ := -350   {Obj beyond picture plane}
end; {initWorld}

procedure GetParams;
begin
   RestoreCrtMode;
   writeln('GraphWld.tpu Demo - Copyright (C) 1989 by Gene Fowler');
   writeln;
   writeln('Only the 3 rotation params to be set, not the plane and');
   writeln('object distances, translations, or placement of the two face');
   writeln('semi-cube. This side is centered on x0,y0 and all four points');
   writeln('have z = 0 - so a 90 degree yaw with 0-roll,0-pitch shows a');
   writeln('straight line. Enter all three 0s when finageling world...to');
   writeln('have an expected square for test measuring. Aspect is in world.');
   writeln;
   write('Yaw angle in degrees (0-360):   ');
   readln(YawRad);
   YawRad := Deg2Rad(YawRad);
   writeln;
   write('Roll angle in degrees (0-360):  ');
   readln(RollRad);
   RollRad := Deg2Rad(RollRad);
   writeln;
   write('Pitch angel in degrees (0-360); ');
   readln(PitchRad);
   PitchRad := Deg2Rad(PitchRad);
   SetGraphMode(GetGraphMode)
end;

begin  {main}
   Directvideo := False;
   InitWorld;
   repeat
     {set rotations, draw, and view}
      GetParams;
      AdjustParams;
      ConstructModel;
      WritePressKey;
      repeat until keypressed;
      GoAgain := ReadKey; {clear key}
     {repeat or quit choice}
      RestoreCRTMode;
      write('Repeat or quit (r/q)? ');
      repeat until keypressed;
      GoAgain := ReadKey;
      SetGraphMode(GetGraphMode);
   until (GoAgain = 'q') or (GoAgain = 'Q');
   CloseGraph
end.
