;*****************************************************************************
;
; This program fragment shows how the multiplex interrupt can be used to
; provide reliable interprocess communications in an MS-DOS environment.
; A single segment is assumed (i.e. a .COM file) throughout this fragment,
; so adjustments will be necessary in a multiple segment situation.
;
; Keith Spitz / CH2M HILL Inc. / May 4, 1988
;
;*****************************************************************************

;
; Define the segmentation.
;
CODE		SEGMENT				; A single segment.
		ASSUME	CS:CODE , DS:CODE	; Everything goes in it.

;
; Program Data.
;
MyPIDHeader	DB	'MYPID'			; Helps me find MYPID if
						; patching is necessary.
MyPID		DB	0C0h			; Assigned multiplex number.
MPXAddr		DD	?			; Address of original multi-
						; plex interrupt vector.

;
; See if this process is already installed.  If so, this program becomes a
; client.  If not, this program installs itself and becomes the multiplex
; handler.
;
CheckInstalled:	mov	ah , MyPID		; PID in AH.
		mov	al , 0			; Get Installed State function.
		call	MPXInt			; Do the interrupt.
		cmp	al , 0			; Not there but OK to install?
		je	DoInstall		; Yes - become handler.
		cmp	al , 1			; Not there and NOT OK to inst?
		je	CantInstall		; Yes - bomb out.
		cmp	al , 0FFh		; Already installed?
		je	AlreadyInstalled	; Yes - become client.
		jmp	Hmmmm			; Hmmm.  Bomb out, I guess.

;
; At this point, the program needs to become the handler process.  It installs
; itself into the multiplex interrupt chain and then (presumably) becomes
; memory resident.
;
DoInstall:	mov	ah , 35h		; Get interrupt vector func.
		mov	al , 2Fh		; For the multiplex interrupt.
		int	21h			; Get vector.
		mov	WORD PTR MPXAddr[0] , bx; Save offset of vector.
		mov	WORD PTR MPXAddr[2] , es; Save segment of vector.
		mov	ah , 25h		; Set interrupt vector func.
		mov	al , 2Fh		; For the multiplex interrupt.
		mov	dx , OFFSET MPXHandler	; Point at handler routine.
		int	21h			; Set new vector.
		...				; Off to do whatever...

;
; If the program gets here, the program has decided it is a client process.
; It will perform a couple of multiplex interupt requests and then quit
; (or whatever).
;
AlreadyInstalled:mov	ah , MyPID		; PID in AH.
		mov	al , <some function>	; Some process func in AL.
		call	MPXInt			; Do the function.
		...				; ... Do other things ...
		mov	ah , MyPID		; PID in AH again.
		mov	al , <another function>	; Another function in AL.
		call	MPXInt			; Do the second function.
		...				; ... Do more other things ...

;
; This is the multiplex interrupt handler.  It will handle only those
; requests appropriate for the current process and pass on requests not
; for this process.  Note that DS is probably not pointing to the right
; place at the onset.
;
MPXHandler	PROC	FAR			; This MUST be a FAR routine.
		cmp	ah , CS: MyPID		; Is this for us?
		jne	MPXHandNext		; No - chain to next handler.
		cmp	al , 0F8h		; Reserved function?
		jae	MPXHandRet		; Yes - return immediately.
		cmp	al , 0			; Get install state function?
		je	MPXHandFunc0		; Yes - handle it.
		...				; Check for other funcs here.
		mov	al , <Invalid function>	; Invalid function.
		jmp	MPXHandRet		; All done.
; Handle the 'Get Install State' function.
MPXHandFunc0:	mov	al , 0FFh		; Yes, we are installed.
		jmp	MPXHandRet		; All done.
; Chain to the next handler, if there is one.
MPXHandNext:	mov	ax , CS: WORD PTR MPXAddr[0] ; Offset of next in chain.
		or	ax , CS: WORD PTR MPXAddr[2] ; OR in segment.
		je	MPXHandRet		; If 0, no one to chain to.
		jmp	CS: MPXAddr		; Else chain to next handler.
; Return from the interrupt.
MPXHandRet:	iret				; All done.
MPXHandler	ENDP				; End of handler procedure.

;
; This routine is used to perform multiplex interrupts.  Direct INT 2Fh's
; should not be called since it is possible that the 2Fh interrupt vector
; has not been initialized in some versions of DOS.
;
MPXInt		PROC	NEAR			; Start of procedure.
		push	ax			; Save AX, BX, and ES ...
		push	bx			; ... while they are used ...
		push	es			; ... to see if INT 2Fh is OK.
		mov	ah , 35h		; Get interrupt vector func.
		mov	al , 2Fh		; For the multiplex interrupt.
		int	21h			; Get vector.
		mov	ax , es			; Get the vector segment.
		or	ax , bx			; Or in the offset.
		pop	es			; Restore registers now...
		pop	bx			; ... (leaving flags alone ...
		pop	ax			; ... for later testing).
		jz	MPXIntRet		; If addr was 0, no vector!
		int	2Fh			; Otherwise OK to do INT 2Fh.
MPXIntRet:	ret				; All done.
MPXInt		ENDP				; End of procedure.

;
; This is the end.
;
CODE		ENDS
