{$Z63,S3,V+,E1,W-,F1,T0}
(* Copyright 1987, John J. Newlin *)
implementation module sheltool(input,output);

function shiftl(target,bits : integer) : integer; external;

function shiftr(target,bits : integer) : integer; external;

function hi(target : integer) : integer; external;

function lo(target : integer) : integer; external;

function upcase(ch : char) : char; external;

procedure exec(var name : string); external;

function delete_file(addr : integer) : integer; external;

procedure longstr(var long : longint; var strng : longstring); external;

procedure save_cursor; external;

procedure hide_cursor; external;

procedure rest_cursor; external;

procedure addlong(var total,n1,n2 : longint); external;

function keycode(var status,ascii,scan : integer) : boolean; external;

procedure scroll(ulx,uly,lrx,lry,lines,attr,dir : integer); external;

procedure savebox(col,row,width,depth,attr : integer); external;

procedure restbox(col,row,width,depth,attr : integer); external;

procedure set_dta(var buffer : buff_type); external;

procedure init_screen; external;

procedure msdos(var regs : regtype); external;

procedure setxy(col,row : integer);  external;

procedure screenwrite(col,row,attr : integer; var str : string); external;

procedure fillstr(var str : string; num : integer; ch : char); external;

procedure move(v1addr,v2addr,bytes : integer); external;

function chdir(var dirname : string) : integer; external;

function mkdir(var dirname : string) : integer; external;

function rmdir(var dirname : string) : integer; external;

procedure getdir(var path : string); external;

function findfirst(var pathname : string; attr : integer) : integer; external;

function findnext : integer; external;

procedure cls(attribute : integer); external;

procedure strng(num : integer; var numstr : string); external;

function abs_read(drive,sectors,start,buff_addr:integer):integer; external;

function set_mem : integer; external;

function video_mode : integer; external;

procedure execute(var command : string);
var l : integer;
begin
  l := length(command);
  command := concat(" ",command," ");
  command[1] := chr(l);
  command[length(command)] := chr(13);
  if length(command) > 126 then return;
  savebox(1,1,80,25,address(screenbuff));
  cls(15);
  rest_cursor;
  setxy(1,1);
  exec(command);
  hide_cursor;
  restbox(1,1,80,25,address(screenbuff));
end;

procedure draw_box(col,row,width,depth : integer);
var x,y : integer;
    side : string;
begin
  fillstr(side,width-2,horiz[1]);
  side := concat(ul,side,ur);
  screenwrite(col,row,main_color,side);
  fillstr(side,width-2,space[1]);
  side := concat(vert,side,vert);
  for y := row+1 to row+depth-1 do screenwrite(col,y,main_color,side);
  fillstr(side,width-2,horiz[1]);
  side := concat(ll,side,lr);
  screenwrite(col,row+depth,main_color,side);
end;

procedure fx(barlen,battr,col,row,attr : integer; var str : string);
begin
  if barlen < length(str) then
    begin
      screenwrite(col,row,attr,str);
      return;
    end
  else
    begin
      while length(str) < barlen do str := concat(str," ");
      screenwrite(col,row,battr,str);
    end;
end;

procedure get_files(var mask : string; var files : file_array;
                    var count : integer);
var dir : buff_type;
begin
  set_dta(dir);
  count := 0;
  if findfirst(mask,16#1F#) = 0 then         {attr bit pattern = 00010111}
     begin
       if dir.filename[1] <> '.' then
         begin
           count := succ(count);
           move(address(dir.attr),address(files[count]),22);
           files[count].desig := 0;
         end;
     end;
   while (count < maxfiles) and (findnext = 0) do
     begin
       if dir.filename[1] <> '.' then
         begin
           count := succ(count);
           move(address(dir.attr),address(files[count]),22);
           files[count].desig := 0;
         end;
     end;
end;

function filedate(code : integer) : str12;
var i,y,m,d : integer;
    ys,ms,ds : str12;
begin
  y := hi(code);
  y := shiftr(y,1) + 80;
  if y > 99 then y := y - 100;
  strng(y,ys);
  m := shiftr(code,1);
  m := lo(m);
  m := shiftr(m,4);
  strng(m,ms);
  if length(ms) = 1 then ms := concat("0",ms);
  d := shiftl(code,3);
  d := lo(d);
  d := shiftr(d,3);
  strng(d,ds);
  if length(ds) = 1 then ds := concat("0",ds);
  filedate := concat(ms,"/",ds,"/",ys);
end;

function filetime(code : integer) : str12;
var h,m : integer;
    hr,mi,x : str12;
begin
  h := hi(code);
  h := shiftr(h,3);
  if h >= 12 then
    begin
      if h > 12 then h := h - 12;
      x := ' p.m.';
    end else x := ' a.m.';
  strng(h,hr);
  if length(hr) = 1 then hr := concat("0",hr);
  m := shiftr(code,6);
  m := lo(m);
  m := shiftl(m,3);
  m := lo(m);
  m := shiftr(m,2);
  strng(m,mi);
  if length(mi) = 1 then mi := concat("0",mi);
  filetime := concat(hr,":",mi,x);
end;

function convert(var st : str12) : str12;
var n,i : integer;
    name : string[13];
begin
  n := pos(".",st);
  if (n > 0) and (n <> 9) then
    begin
      name := '            ';
      move(address(st[1]),address(name[1]),n-1);
      move(address(st[n]),address(name[9]),length(st)-n+1);
    end 
  else name := st;
  name[9] := chr(32);
  while length(name) < 12 do name := concat(name," ");
  convert := name;
end;

procedure sort_files(var files : file_array; var items : integer);
var jump,i,j : integer;
    done : boolean;
    temp : file_type;
begin
  jump := items;
  while jump > 1 do
    begin
      jump := jump div 2;
      repeat
        done := true;
        for j := 1 to items - jump do
          begin
            i := j + jump;
            if files[j].name > files[i].name then
              begin
                temp := files[j];
                files[j] := files[i];
                files[i] := temp;
                done := false;
              end;
          end;
      until done;
    end;
end;

function format_num(long : longint; width : integer) : string;
var str : longstring;
     n,i,temp : integer;
begin
  longstr(long,str);
  n := length(str);
  if n in [4..6] then insert(",",str,n-2);
  if n in [7..9] then
    begin
      insert(",",str,n-5);
      insert(",",str,n-1);
    end;
  n := length(str);
  if width > n then for i := 1 to (width - n) do str := concat(" ",str);
  format_num := str;
end;

begin
  entry_str := '';
  color := video_mode <> 7;
  if color then attr := 16#0B# else attr := 16#0F#;
  init_screen;
end.

