; Listing 2.
; Program to illustrate operation of set/reset circuitry to force
;  setting of memory that already contains data.
; Assembled with MASM 4.0, linked with LINK 3.51.
; Copyright by Michael Abrash, 4/26/87.
;
stack	segment	para stack 'STACK'
	db	512 dup(?)
stack	ends
;
EGA_VIDEO_SEGMENT	equ	0a000h	;EGA display memory segment
;
; EGA register equates.
;
TS_INDEX	equ	3c4h	;TS index register
TS_MAP_MASK	equ	2	;TS map mask register
GC_INDEX	equ	3ceh	;GC index register
GC_SET_RESET	equ	0	;GC set/reset register
GC_ENABLE_SET_RESET equ	1	;GC enable set/reset register
;
; Macro to set indexed register INDEX of TS chip to SETTING.
;
SETTS	macro	INDEX, SETTING
	mov	dx,TS_INDEX
	mov	al,INDEX
	out	dx,al
	inc	dx
	mov	al,SETTING
	out	dx,al
	dec	dx
	endm
;
; Macro to set indexed register INDEX of GC chip to SETTING.
;
SETGC	macro	INDEX, SETTING
	mov	dx,GC_INDEX
	mov	al,INDEX
	out	dx,al
	inc	dx
	mov	al,SETTING
	out	dx,al
	dec	dx
	endm
;
cseg	segment	para public 'CODE'
	assume	cs:cseg
start	proc	near
;
; Select 640x350 graphics mode.
;
	mov	ax,010h
	int	10h
;
	mov	ax,EGA_VIDEO_SEGMENT
	mov	es,ax			;point to video memory
;
; Draw 18 10-scan-line high horizontal bars in green, 10 scan lines apart.
;
	SETTS	TS_MAP_MASK,02h		;map mask setting enables only
					; plane 1, the green plane
	sub	di,di		;start at beginning of video memory
	mov	al,0ffh
	mov	bp,18		;# bars to draw
HorzBarLoop:
	mov	cx,80*10	;# bytes per horizontal bar
	rep stosb		;draw bar
	add	di,80*10	;point to start of next bar
	dec	bp
	jnz	HorzBarLoop
;
; Fill screen with blue, using set/reset to force plane 0 to 1's and all
; other plane to 0's.
;
	SETTS	TS_MAP_MASK,0fh		;must set map mask to enable all
					; planes, so set/reset values can
					; be written to memory
	SETGC	GC_ENABLE_SET_RESET,0fh ;CPU data to all planes will be
					; replaced by set/reset value
	SETGC	GC_SET_RESET,01h	;set/reset value is 0ffh for plane 0
					; (the blue plane) and 0 for other
					; planes
	sub	di,di
	mov	cx,80*350		;# bytes per screen
	mov	al,0ffh			;since set/reset is enabled for all
					; planes, the CPU data is ignored-
					; only the act of writing is
					; important
	rep stosb			;perform fill (affects all planes)
;
; Turn off set/reset.
;
	SETGC	GC_ENABLE_SET_RESET,0
;
; Exit to DOS.
;
	mov	ah,4ch
	int	21h
start	endp
cseg	ends
	end	start

