#define lint_args
#include <stdio.h>
#include <string.h>
#include <ctype.h>
/************************************************************/
FILE  *infile, *outfile;
char  **args, *outname, outspec[64];
int   argnum, nspaces = 5;
/************************************************************/
/*global*/  void getparms(void);
/*global*/  void make_outname(void);
/*global*/  void get_nspaces(void);
/*global*/  void openfiles(void);
/*global*/  void dotabs(void);
/************************************************************/
main (argc,argv)    /* DOTAB  srcefile nspaces [outfile]   */
char  *argv[];
{
args = argv;
argnum = argc;
getparms ();
openfiles ();
dotabs ();

if (fcloseall() != 2) {
  fprintf (stderr,
    "error occurred when closing files");
  exit (1);
  }
exit (0);
}
/************************************************************/
/************************************************************/
void getparms () {

switch (argnum) {

  case 1 :  /* nothing entered */
    fprintf (stderr, \
      "DOTAB sourcefile nspaces outfile  \n");
      exit (1);

  case 2 :  /* outfile and nspaces not entered */
    make_outname ();
    break;

  case 3 :  /* outfile not entered */
    make_outname ();
    get_nspaces ();
    break;

  default : /* all parms (and maybe more) entered */
    outname = args[3];
    get_nspaces ();
  }
}

void make_outname ()  {
char *extension = ".tab", *from, *out;

    outname = out = outspec;
    for (from=args[1]; (*from != '.'); out++, from++) {
      if (*from == '\0') break;
      *out = *from;
      }
    *out = '\0';
    outname = strcat (outname,extension);
}

void get_nspaces () {
char space[3];

    strcpy (space,args[2]);
    if (strlen(space) == 1) {
      if (isdigit(space[0])) nspaces = atoi(space);
      }
    if (strlen(space) == 2) {
      if (isdigit(space[0]) && isdigit(space[1])) \
          nspaces = atoi(space);
      }
}
/************************************************************/
/************************************************************/
void openfiles () {

if ((infile=fopen(args[1],"r"))==NULL) {
  fprintf (stderr,
    "couldn't open input file: %s",args[1]);
  exit (1);
  }

if ((outfile=fopen(outname,"w"))==NULL) {
  fprintf (stderr,
    "couldn't open output file: %s",outname);
  exit (1);
  }
}
/************************************************************/
/************************************************************/
void dotabs () {
  char inline[147], outline[246];
  int i;

  for (i=0; i < nspaces; outline[i++]=' ');

  while (*fgets(inline,145,infile) != NULL) {
    outline[i] = '\0';
    strcat (outline,inline);
    fputs (outline,outfile);
    }
}
/************************************************************/
