10 REM  PROGRAM SURFGEN GENERATES VALUES OF A FUNCTION OF TWO VARIABLES.
20 REM  THE PROGRAM WRITES THE VALUES ALONG WITH PLOT COMMANDS TO A FILE
30 REM  NAMED SURFDATA.PLT; THE VALUES ARE THEN PLOTTED BY USING THE SHELL
40 REM  COMMAND TO RUN THE SPLOT PROGRAM.
50 REM
60 REM  COPYRIGHT 1988, 1989 BY WILLIAM G. HOOD
70 REM
80 REM  WARNING: DO NOT RENUMBER!
90 REM
100 CLS: KEY OFF
105 DIM Z.(201), X.(201)
110 PRINT"This program plots a function of two variables defined by a"
120 PRINT"subroutine which follows the main program.  The subroutine must"
130 PRINT"set dependent variable Y equal to a function evaluated at the"
140 PRINT"current value of the independent variables X and Z."
150 PRINT
160 INPUT"Do you want to see current function (N/Y)"; A$: A$=LEFT$(A$,1)
170 IF A$="Y" OR A$="y" THEN CLS: LIST 1000-1999: END
180 REM
190 OPEN "SURFDATA.PLT" FOR OUTPUT AS #2
200 PRINT: LINE INPUT"Title? "; TITLE$: PRINT#2,"TITLE "+TITLE$
205 PRINT: LINE INPUT"Z-Axis Label? ";LZ$: PRINT#2,"ZLABEL "+LZ$
215 LINE INPUT"X-Axis Label? ";LX$: PRINT#2,"XLABEL "+LX$
220 LINE INPUT"Y-Axis Label? ";LY$: PRINT#2,"YLABEL "+LY$
222 PRINT: INPUT"Log Z-Axis (N/Y)"; A$: A$=LEFT$(A$,1)
224 IF A$="Y" OR A$="y" THEN PRINT#2,"LOGZ"
230 INPUT"Log X-Axis (N/Y)"; A$: A$=LEFT$(A$,1)
240 IF A$="Y" OR A$="y" THEN PRINT#2,"LOGX"
250 INPUT"Log Y-Axis (N/Y)"; A$: A$=LEFT$(A$,1)
260 IF A$="Y" OR A$="y" THEN PRINT#2,"LOGY"
290 REM
300 PRINT: PRINT"Enter initial value, final value & step size of ";
305 PRINT"independent variable Z"
310 INPUT V$: IF V$ <> "" GOTO 320
315     INPUT"Initial Value, Final Value, Step Size"; V$: IF V$="" GOTO 315
320   P=1: GOSUB 680: ZI. = V: GOSUB 680: ZF. = V: GOSUB 680: ZS. = V
325   IF ZS. <= 0 THEN PRINT"ERROR: INVALID STEP SIZE": GOTO 315
330   NZ. = INT( (ZF.-ZI.)/ZS. + 1.5 )
335   IF NZ. < 2 THEN PRINT"ERROR: INVALID RANGE": GOTO 315
340   IF NZ. > 201 THEN PRINT"ERROR: TOO MANY POINTS - MAX OF 201": GOTO 315
350 PRINT: PRINT"Enter initial value, final value & step size of ";
355 PRINT"independent variable X"
360 INPUT V$: IF V$ <> "" GOTO 370
365     INPUT"Initial Value, Final Value, Step Size"; V$: IF V$="" GOTO 365
370   P=1: GOSUB 680: XI. = V: GOSUB 680: XF. = V: GOSUB 680: XS. = V
375   IF XS. <= 0 THEN PRINT"ERROR: INVALID STEP SIZE": GOTO 365
380   NX. = INT( (XF.-XI.)/XS. + 1.5 )
385   IF NX. < 2 THEN PRINT"ERROR: INVALID RANGE": GOTO 365
390   IF NX. > 201 THEN PRINT"ERROR: TOO MANY POINTS - MAX OF 201": GOTO 365
395 REM
470 PRINT:PRINT"Calculating ... Please wait ..."
475 PRINT#2,"READZ ";NZ.
480 FOR I.=1 TO NX. : X.(I.) = XI. + (I.-1)*XS. : NEXT I.
482 FOR I.=1 TO NZ. : Z.(I.) = ZI. + (I.-1)*ZS. : PRINT#2, Z.(I.) : NEXT I.
484 PRINT#2,"READTAB ";NZ.;" ";NX.
490 FOR I.=1 TO NX.
500   X = X.(I.)
505   PRINT#2, X.(I.);
510   FOR J.=1 TO NZ.
512     Z = Z.(J.): GOSUB 1100: PRINT#2," ";Y;
514     IF ( J. AND 3 ) = 0 OR J. = NZ. THEN PRINT#2,""
516   NEXT J.
520 NEXT I.
545 PRINT#2,"PLOT3D"; : IF NZ. > 20 THEN PRINT#2," SURFACE";
546 PRINT#2,"" : PRINT#2,"KEYBOARD"
550 CLOSE#2
560 REM
570 PRINT:PRINT"Press the ENTER key to display the plot";
580 PRINT" - press the ESC key to clear the plot."
590 A$=INKEY$: IF A$<>"" GOTO 590
600 A$=INKEY$: IF A$="" GOTO 600
610 IF ASC(A$)<>13 GOTO 600
620 SHELL( "SPLOT SURFDATA.PLT" )
630 END
670 REM EXTRACTS V FROM V$ STARTING AT POSITION P
680 P2=LEN(V$)
690 IF MID$(V$,P,1)=" " AND P<=P2 THEN P=P+1: GOTO 690
700 P0=P: IF P0>P2 THEN V=0: RETURN
710 IF MID$(V$,P,1)<>" " AND P<=P2 THEN P=P+1: GOTO 710
720 V = VAL( MID$( V$, P0, P-P0 ) )
730 RETURN
1000 REM
1010 REM NOTE: To avoid conflict with main program variables,
1020 REM       do not use variable names that contain a period.
1030 REM
1100 REM Subroutine must set variable Y = function(X,Z) after this line #
1110 REM Insert here GOTO 1210 to plot another functions
1120 REM Let X and Z vary from -12.5 to 12.5 with a step of .5 or .25
1130 R = SQR( X*X + Z*Z ): GOSUB 1160: Y = S
1140 RETURN
1150 REM S = SINC( R )
1160 IF R <> 0 THEN S = SIN(R) / R ELSE S = 1
1170 RETURN
1200 REM Let X and Z vary from -90 to +90 with a step of 6 or 3
1210 R = 9 * SIN( 1.745329E-02 * Z ): GOSUB 1160: YZ = S
1220 R = 6 * SIN( 1.745329E-02 * X ): GOSUB 1160: YX = S
1230 Y = YZ * YX
1240 RETURN
