;========================================================================

; Copyright (C) 1991 by Jan.Engvald@ldc.lu.se, see file COPYING.

;************************************************************************
;*		SetTime
;************************************************************************

SetTime 	proc	near
		push	cs
		push	cs
		pop	ds
		pop	es
		cld
						; convert from network byte
		mov	cx,cTime		;   order
		xchg	ch,cl
		mov	bx,cTime+2
		xchg	bh,bl

		mov	dx,tzoffset+2		;   and apply time zone
		xchg	dh,dl
		sub	bx,dx
		mov	ax,tzoffset		;   offset
		xchg	ah,al
		sbb	cx,ax

		mov	ax,AlterTime		; add alter-days
		imul	m6hour
		shl	ax,1
		rcl	dx,1
		shl	ax,1
		rcl	dx,1
		add	bx,ax
		adc	cx,dx

		mov	ax,AlterTime+2		; add alter-time
		mov	dx,AlterTime+4
		add	bx,ax
		adc	cx,dx

		mov	si,AlgPtr
		or	si,si			; any daylight algorithm?
		jnz	DoDls
		jmp	SetNoDls
  DoDls:
		push	bx
		push	cx
		add	si,4
		lodsw				; from switching time
		imul	m1
		sub	bx,ax
		sbb	cx,dx

		call	DateTimeCalc		; dst start evaluation

		cmp	si,offset AlgTab.Apa0	; four entry part?
		jl	SingleEntry

		mov	al,AlgEntryLen
		mul	cNonLeapYear
		add	si,ax
		cmp	si,offset AlgTab.Ais0	; acyclic entry?
		jb	SingleEntry

		cmp	cYear,WARNYEAR
		jb	SingleEntry

		mov	MsgTermStop,' '		; activate warning msg
  SingleEntry:
		mov	bp,cDayOfYear
		lodsw				; from switching weekday
		cmp	al,SAT
		ja	FromDate
		dec	bp
		cmp	ax,cWday
		jg	CurWeekF
		add	bp,7
  CurWeekF:
		sub	bp,cWday
		add	bp,ax
  FromDate:
		pop	cx
		pop	bx
		push	bx
		push	cx
		lodsw				; from switching week

		push	ax
		lodsw				; until switching time
		imul	m1
		sub	bx,ax
		sbb	cx,dx

		call	DateTimeCalc		; dst end evaluation

		mov	di,cDayOfYear
		pop	dx

		lodsw				; until switching weekday
		cmp	al,SAT
		ja	UntilDate
		dec	di
		cmp	ax,cWday
		jg	CurWeekU
		add	di,7
  CurWeekU:
		sub	di,cWday
		add	di,ax
  UntilDate:
		lodsw				; until switching week
		test	cNonLeapYear,011b
		jnz	SetNotLeap
		cmp	ax,31+28
		jbe	SetChkLU
		inc	ax
  SetChkLU:
		cmp	dx,31+28
		jbe	SetNotLeap
		inc	dx
  SetNotLeap:
		pop	cx
		pop	bx
		cmp	ax,dx			; north or south of equator?
		jl	SetSouth
		cmp	dx,bp			; to do or not to do dls?
		jg	SetNoDls
		jmp	short SetChkUntil
  SetSouth:
		cmp	dx,bp			; to do or not to do dls?
		jle	DoDLSaving
  SetChkUntil:
		cmp	di,ax
		jge	SetNoDls
  DoDLSaving:
		or	GenFlags,DSTNOW
		lodsw				; dst advance time
		mov	DstAdvance,ax
		imul	m1
		add	bx,ax
		adc	cx,dx
  SetNoDls:
		call	DateTimeCalc		; calculate date and time

		test	Flagword,DONT_SETTIME	; did we use alter argument?
		jz	SetPCtime

		mov	di,offset msgset
		mov	cx,12
		mov	al,' '
		rep	stosb			; clear "Clock set to"
		jmp	SkipTimeset
  SetPCtime:
		mov	cx,cYear
		mov	dh,byte ptr cMonth
		mov	dl,byte ptr Cday
		mov	ah,2Bh			; set date
		int	21h
		or	al,al
		jz	DateOK
		mov	al,5			; error code 5
		call	terminate
  DateOK:
		mov	ch,byte ptr cHour
		mov	cl,byte ptr cMinute
		mov	dh,byte ptr cSecond
		mov	dl,99
		mov	ah,2Dh			; set time
		int	21h
		or	al,al
		jz	TimeOK
		mov	al,6			; error code 6
		call	terminate
  TimeOK:
  SkipTimeset:					; edit time display msg
		mov	al,byte ptr cWday
		mul	m6
		add	ax,offset Weekdays
		mov	si,ax
		mov	di,offset msgweek
		mov	cx,3
		rep	movsw			; copy weekday string
	        
		mov	si,offset cYear
		mov	di,offset msgyear
		mov	ch,'-'
		mov	cl,3
		call	PutNums 		; put date

		mov	di,offset msghour
		mov	ch,':'
		mov	cl,3
		call	PutNums 		; put time

		mov	si,offset RespondingIpNr
		mov	di,offset msgts
		call	PutIpNum		; put time server IP #

		mov	dx,offset msgset
		mov	ah,9
		int	21h			; display string

		ret
SetTime 	endp



;************************************************************************
;*		DateTimeCalc
;************************************************************************

DateTimeCalc	proc	near
		mov	ax,bx
		mov	dx,cx
		push	si
		push	ax			; save seconds since
		push	dx			;   year 1900

		mov	si,offset Ytab
		mov	cx,4*64
		call	SearchAndSub		; find and subtract years
		add	cx,1964
		mov	cYear,cx		; set year

		push	ax			; reminder still too big
		push	dx			;   for 16 bits,
		shr	dx,1			;   have to
		rcr	ax,1			;   divide by 2
		div	m12hour
		inc	ax
		mov	cDayOfYear,ax		; set day within year

		pop	dx			; restore seconds within year
		pop	ax

		and	cl,011b 		; extract leap year index
		mov	cNonLeapYear,cl
		mov	si,offset Motab
		jnz	NoLeapYear
		mov	si,offset Mltab
  NoLeapYear:
		mov	cx,4*16
		call	SearchAndSub		; find and subtract month
		inc	cx
		mov	cMonth,cx		; set month within year

		shr	dx,1			; reminder still too big
		rcr	ax,1			;   for 16 bits, have to
		rcr	bx,1			;   divide by 2
		div	m12hour 		; divide by 24hr/2
		inc	ax
		mov	cDay,ax 		; set day within month

		mov	ax,dx
		xor	dx,dx
		shl	bx,1			; recover lost bit
		rcl	ax,1			;   into reminder
		rcl	dx,1
		div	mhour			; divide by 3600
		mov	cHour,ax		; set hour within day

		mov	ax,dx
		div	m60b			; divide by 60
		mov	dl,ah
		xor	dh,dh
		mov	cSecond,dx		; set second within minute
		xor	ah,ah
		mov	cMinute,ax		; set minute within hour

		pop	dx			; restore seconds since
		pop	ax			;   year 1900
		shr	dx,1			; too big for 16 bits...
		rcr	ax,1
		div	m12hour 		; calculate days since 1900
		inc	ax
		xor	dx,dx			; calculate weeks since 1900
		div	m7
		mov	cWday,dx		; set weekday
		pop	si
		ret
DateTimeCalc	endp

